/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorpusChar {
    private static Logger logger = LoggerFactory.getLogger(CorpusChar.class);
    private Map<String, Set<String>> charMap;
    private Map<String, Set<String>> char_dict;

    public CorpusChar(String charlistFilename) {
        this.charMap = this.readDict(charlistFilename);
    }

    Map<String, Set<String>> getCharMap() {
        return this.charMap;
    }

    private Map<String, Set<String>> readDict(String filename) {
        logger.info("Loading character dictionary file from " + filename);
        try {
            String DetectorLine;
            InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(filename);
            BufferedReader DetectorReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            this.char_dict = Generics.newHashMap();
            while ((DetectorLine = DetectorReader.readLine()) != null) {
                String[] fields = DetectorLine.split("\t");
                String tag = fields[0];
                Set<String> chars = this.char_dict.get(tag);
                if (chars == null) {
                    chars = Generics.newHashSet();
                    this.char_dict.put(tag, chars);
                }
                chars.add(fields[1]);
            }
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return this.char_dict;
    }

    public String getTag(String a1, String a2) {
        Map<String, Set<String>> h1 = this.getCharMap();
        Set<String> h2 = h1.get(a1);
        if (h2 == null) {
            return "0";
        }
        if (h2.contains(a2)) {
            return "1";
        }
        return "0";
    }
}

