/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.Serializable;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class RegexStringFilter
implements Predicate<String>,
Serializable {
    final Pattern pattern;

    public RegexStringFilter(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public boolean test(String text) {
        return this.pattern.matcher(text).matches();
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RegexStringFilter)) {
            return false;
        }
        return ((RegexStringFilter)other).pattern.equals(this.pattern);
    }
}

