/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.io;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.tagger.io.TaggedFileReader;
import edu.stanford.nlp.tagger.io.TaggedFileRecord;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TSVTaggedFileReader
implements TaggedFileReader {
    final BufferedReader reader;
    final String filename;
    final int wordColumn;
    final int tagColumn;
    List<TaggedWord> next = null;
    int linesRead = 0;
    static final int DEFAULT_WORD_COLUMN = 0;
    static final int DEFAULT_TAG_COLUMN = 1;

    public TSVTaggedFileReader(TaggedFileRecord record) {
        this.filename = record.file;
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), record.encoding));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.wordColumn = record.wordColumn == null ? 0 : record.wordColumn;
        this.tagColumn = record.tagColumn == null ? 1 : record.tagColumn;
        this.primeNext();
    }

    @Override
    public Iterator<List<TaggedWord>> iterator() {
        return this;
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public List<TaggedWord> next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        List<TaggedWord> thisIteration = this.next;
        this.primeNext();
        return thisIteration;
    }

    void primeNext() {
        String line = "";
        while (line.trim().equals("")) {
            try {
                line = this.reader.readLine();
                ++this.linesRead;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (line != null) continue;
            this.next = null;
            return;
        }
        this.next = new ArrayList<TaggedWord>();
        while (line != null && !line.trim().equals("")) {
            String[] pieces = line.split("\t");
            if (pieces.length <= this.wordColumn || pieces.length <= this.tagColumn) {
                throw new IllegalArgumentException("File " + this.filename + " line #" + this.linesRead + " too short");
            }
            String word = pieces[this.wordColumn];
            String tag = pieces[this.tagColumn];
            this.next.add(new TaggedWord(word, tag));
            try {
                line = this.reader.readLine();
                ++this.linesRead;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

