/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.semgraph.semgrex.CoordinationPattern;
import edu.stanford.nlp.semgraph.semgrex.GraphRelation;
import edu.stanford.nlp.semgraph.semgrex.NodePattern;
import edu.stanford.nlp.semgraph.semgrex.ParseException;
import edu.stanford.nlp.semgraph.semgrex.SemgrexParserConstants;
import edu.stanford.nlp.semgraph.semgrex.SemgrexParserTokenManager;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.semgraph.semgrex.SimpleCharStream;
import edu.stanford.nlp.semgraph.semgrex.Token;
import edu.stanford.nlp.util.Generics;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SemgrexParser
implements SemgrexParserConstants {
    private boolean underNegation = false;
    private boolean underNodeNegation = false;
    private Set<String> knownVariables = Generics.newHashSet();
    public SemgrexParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[27];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public final SemgrexPattern Root() throws ParseException {
        SemgrexPattern node;
        Token reverse = null;
        ArrayList<SemgrexPattern> children = new ArrayList<SemgrexPattern>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                reverse = this.jj_consume_token(5);
                node = this.SubNode(GraphRelation.ALIGNED_ROOT);
                this.jj_consume_token(11);
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 23: {
                node = this.SubNode(GraphRelation.ROOT);
                children.add(node);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(12);
                    node = this.SubNode(GraphRelation.ITERATOR);
                    children.add(node);
                }
                this.jj_consume_token(11);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (children.size() <= 1) {
            return node;
        }
        return new CoordinationPattern(true, children, true);
    }

    public final SemgrexPattern SubNode(GraphRelation r) throws ParseException {
        SemgrexPattern result = null;
        SemgrexPattern child = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                result = this.SubNode(r);
                this.jj_consume_token(14);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 17: 
                    case 18: 
                    case 19: {
                        child = this.RelationDisj();
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                if (child != null) {
                    ArrayList<SemgrexPattern> newChildren = new ArrayList<SemgrexPattern>();
                    newChildren.addAll(result.getChildren());
                    newChildren.add(child);
                    result.setChild(new CoordinationPattern(false, newChildren, true));
                }
                return result;
            }
            case 17: 
            case 19: 
            case 23: {
                result = this.ModNode(r);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 17: 
                    case 18: 
                    case 19: {
                        child = this.RelationDisj();
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                    }
                }
                if (child != null) {
                    result.setChild(child);
                }
                return result;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SemgrexPattern RelationDisj() throws ParseException {
        ArrayList<SemgrexPattern> children = new ArrayList<SemgrexPattern>();
        SemgrexPattern child = this.RelationConj();
        children.add(child);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(15);
            child = this.RelationConj();
            children.add(child);
        }
        if (children.size() == 1) {
            return child;
        }
        return new CoordinationPattern(false, children, false);
    }

    public final SemgrexPattern RelationConj() throws ParseException {
        ArrayList<SemgrexPattern> children = new ArrayList<SemgrexPattern>();
        SemgrexPattern child = this.ModRelation();
        children.add(child);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: 
                case 5: 
                case 6: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    this.jj_consume_token(16);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                }
            }
            child = this.ModRelation();
            children.add(child);
        }
        if (children.size() == 1) {
            return child;
        }
        return new CoordinationPattern(false, children, true);
    }

    public final SemgrexPattern ModRelation() throws ParseException {
        SemgrexPattern child;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                child = this.RelChild();
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                boolean startUnderNeg = this.underNegation;
                this.underNegation = true;
                child = this.RelChild();
                this.underNegation = startUnderNeg;
                child.negate();
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                child = this.RelChild();
                child.makeOptional();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return child;
    }

    public final SemgrexPattern RelChild() throws ParseException {
        SemgrexPattern child;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                child = this.RelationDisj();
                this.jj_consume_token(20);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                child = this.Relation();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return child;
    }

    public final SemgrexPattern Relation() throws ParseException {
        SemgrexPattern node;
        Token rel = null;
        Token relnType = null;
        Token numArg = null;
        Token numArg2 = null;
        Token name = null;
        boolean pC = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 6: {
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        numArg = this.jj_consume_token(6);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                this.jj_consume_token(21);
                                numArg2 = this.jj_consume_token(6);
                                break block4;
                            }
                        }
                        this.jj_la1[10] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                    }
                }
                rel = this.jj_consume_token(4);
                block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: 
                    case 10: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                relnType = this.jj_consume_token(6);
                                break block10;
                            }
                            case 10: {
                                relnType = this.jj_consume_token(10);
                                break block10;
                            }
                        }
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        name = this.jj_consume_token(6);
                        break block0;
                    }
                }
                this.jj_la1[14] = this.jj_gen;
                break;
            }
            case 5: {
                rel = this.jj_consume_token(5);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        GraphRelation reln = numArg == null && numArg2 == null ? GraphRelation.getRelation(rel != null ? rel.image : null, relnType != null ? relnType.image : null, name != null ? name.image : null) : (numArg2 == null ? GraphRelation.getRelation(rel != null ? rel.image : null, relnType != null ? relnType.image : null, Integer.parseInt(numArg.image), name != null ? name.image : null) : GraphRelation.getRelation(rel != null ? rel.image : null, relnType != null ? relnType.image : null, Integer.parseInt(numArg.image), Integer.parseInt(numArg2.image), name != null ? name.image : null));
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 19: 
            case 23: {
                node = this.ModNode(reln);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                node = this.SubNode(reln);
                this.jj_consume_token(14);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public final SemgrexPattern NodeDisj(GraphRelation r) throws ParseException {
        ArrayList<SemgrexPattern> children = new ArrayList<SemgrexPattern>();
        this.jj_consume_token(19);
        SemgrexPattern child = this.NodeConj(r);
        children.add(child);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(15);
            child = this.NodeConj(r);
            children.add(child);
        }
        this.jj_consume_token(20);
        if (children.size() == 1) {
            return child;
        }
        return new CoordinationPattern(true, children, false);
    }

    public final SemgrexPattern NodeConj(GraphRelation r) throws ParseException {
        ArrayList<SemgrexPattern> children = new ArrayList<SemgrexPattern>();
        SemgrexPattern child = this.ModNode(r);
        children.add(child);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: 
                case 17: 
                case 19: 
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    this.jj_consume_token(16);
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                }
            }
            child = this.ModNode(r);
            children.add(child);
        }
        if (children.size() == 1) {
            return child;
        }
        return new CoordinationPattern(true, children, true);
    }

    public final SemgrexPattern ModNode(GraphRelation r) throws ParseException {
        SemgrexPattern child;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 23: {
                child = this.Child(r);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                boolean startUnderNeg = this.underNodeNegation;
                this.underNodeNegation = true;
                child = this.Child(r);
                this.underNodeNegation = startUnderNeg;
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return child;
    }

    public final SemgrexPattern Child(GraphRelation r) throws ParseException {
        SemgrexPattern child;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                child = this.NodeDisj(r);
                break;
            }
            case 23: {
                child = this.Description(r);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return child;
    }

    public final NodePattern Description(GraphRelation r) throws ParseException {
        Token name = null;
        boolean link = false;
        boolean isRoot = false;
        boolean isEmpty = false;
        Token attr = null;
        Token value = null;
        Map<String, String> attributes = Generics.newHashMap();
        this.jj_consume_token(23);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                attr = this.jj_consume_token(6);
                this.jj_consume_token(12);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        value = this.jj_consume_token(6);
                        break;
                    }
                    case 10: {
                        value = this.jj_consume_token(10);
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (attr != null && value != null) {
                    attributes.put(attr.image, value.image);
                }
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: {
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                            break block20;
                        }
                    }
                    this.jj_consume_token(24);
                    attr = this.jj_consume_token(6);
                    this.jj_consume_token(12);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            value = this.jj_consume_token(6);
                            break;
                        }
                        case 10: {
                            value = this.jj_consume_token(10);
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (attr == null || value == null) continue;
                    attributes.put(attr.image, value.image);
                }
                this.jj_consume_token(25);
                break;
            }
            case 9: {
                attr = this.jj_consume_token(9);
                this.jj_consume_token(25);
                isRoot = true;
                break;
            }
            case 8: {
                attr = this.jj_consume_token(8);
                this.jj_consume_token(25);
                isEmpty = true;
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                link = true;
                name = this.jj_consume_token(6);
                String nodeName = name.image;
                if (this.underNegation) {
                    if (this.knownVariables.contains(nodeName)) break;
                    throw new ParseException("Cannot add new variable names under negation.  Node '" + nodeName + "' not seen before");
                }
                this.knownVariables.add(nodeName);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        NodePattern pat = new NodePattern(r, this.underNodeNegation, attributes, isRoot, isEmpty, name != null ? name.image : null);
        if (link) {
            pat.makeLink();
        }
        return pat;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{4096, 9052192, 917616, 917616, 9052160, 32768, 983152, 65536, 917616, 524400, 0x200000, 64, 1088, 1088, 0x400000, 112, 9052160, 32768, 0x8B0000, 65536, 0x8A0000, 0x880000, 1088, 0x1000000, 1088, 33555264, 0x400000};
    }

    public SemgrexParser(InputStream stream) {
        this(stream, null);
    }

    public SemgrexParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SemgrexParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SemgrexParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SemgrexParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SemgrexParser(SemgrexParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SemgrexParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[26];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 27; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 26; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SemgrexParser.jj_la1_init_0();
    }
}

