/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.Scored;
import edu.stanford.nlp.util.ScoredComparator;
import edu.stanford.nlp.util.ScoredObject;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class ShiftReduceParserQuery
implements ParserQuery {
    Debinarizer debinarizer = new Debinarizer(false);
    List<? extends HasWord> originalSentence;
    private State initialState;
    private State finalState;
    Tree debinarized;
    boolean success;
    boolean unparsable;
    private List<State> bestParses;
    final ShiftReduceParser parser;
    List<ParserConstraint> constraints = null;
    private static TregexPattern rearrangeFinalPunctuationTregex = TregexPattern.compile("__ !> __ <- (__=top <- (__ <<- (/[.]|PU/=punc < /[.!?\u3002\uff01\uff1f]/ ?> (__=single <: =punc))))");
    private static TsurgeonPattern rearrangeFinalPunctuationTsurgeon = Tsurgeon.parseOperation("[move punc >-1 top] [if exists single prune single]");

    public ShiftReduceParserQuery(ShiftReduceParser parser) {
        this.parser = parser;
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence) {
        this.originalSentence = sentence;
        this.initialState = ShiftReduceParser.initialStateFromTaggedSentence(sentence);
        return this.parseInternal();
    }

    public boolean parse(Tree tree) {
        this.originalSentence = tree.yieldHasWord();
        this.initialState = ShiftReduceParser.initialStateFromGoldTagTree(tree);
        return this.parseInternal();
    }

    private boolean parseInternal() {
        int maxBeamSize = Math.max(this.parser.op.testOptions().beamSize, 1);
        this.success = true;
        this.unparsable = false;
        PriorityQueue<Scored> beam = new PriorityQueue<Scored>(maxBeamSize + 1, ScoredComparator.ASCENDING_COMPARATOR);
        beam.add(this.initialState);
        while (beam.size() > 0) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            PriorityQueue<Scored> oldBeam = beam;
            beam = new PriorityQueue<Scored>(maxBeamSize + 1, ScoredComparator.ASCENDING_COMPARATOR);
            State bestState = null;
            for (State state : oldBeam) {
                if (Thread.interrupted()) {
                    throw new RuntimeInterruptedException();
                }
                Collection<ScoredObject<Integer>> predictedTransitions = this.parser.model.findHighestScoringTransitions(state, true, maxBeamSize, this.constraints);
                for (ScoredObject<Integer> predictedTransition : predictedTransitions) {
                    Transition transition = this.parser.model.transitionIndex.get(predictedTransition.object());
                    State newState = transition.apply(state, predictedTransition.score());
                    if (bestState == null || bestState.score() < newState.score()) {
                        bestState = newState;
                    }
                    beam.add(newState);
                    if (beam.size() <= maxBeamSize) continue;
                    beam.poll();
                }
            }
            if (beam.size() == 0) {
                for (State state : oldBeam) {
                    Transition transition = this.parser.model.findEmergencyTransition(state, this.constraints);
                    if (transition == null) continue;
                    State newState = transition.apply(state);
                    if (bestState == null || bestState.score() < newState.score()) {
                        bestState = newState;
                    }
                    beam.add(newState);
                }
            }
            if (bestState != null && !bestState.isFinished()) continue;
            break;
        }
        if (beam.size() == 0) {
            this.success = false;
            this.unparsable = true;
            this.debinarized = null;
            this.finalState = null;
            this.bestParses = Collections.emptyList();
        } else {
            this.bestParses = Generics.newArrayList(beam);
            Collections.sort(this.bestParses, beam.comparator());
            Collections.reverse(this.bestParses);
            this.finalState = this.bestParses.get(0);
            this.debinarized = this.debinarizer.transformTree(this.finalState.stack.peek());
            this.debinarized = Tsurgeon.processPattern(rearrangeFinalPunctuationTregex, rearrangeFinalPunctuationTsurgeon, this.debinarized);
        }
        return this.success;
    }

    @Override
    public boolean parseAndReport(List<? extends HasWord> sentence, PrintWriter pwErr) {
        boolean success = this.parse(sentence);
        return success;
    }

    public Tree getBestBinarizedParse() {
        return this.finalState.stack.peek();
    }

    public List<Transition> getBestTransitionSequence() {
        return this.finalState.transitions.asList();
    }

    @Override
    public double getPCFGScore() {
        return this.finalState.score;
    }

    @Override
    public Tree getBestParse() {
        return this.debinarized;
    }

    @Override
    public Tree getBestPCFGParse() {
        return this.debinarized;
    }

    @Override
    public Tree getBestDependencyParse(boolean debinarize) {
        return null;
    }

    @Override
    public Tree getBestFactoredParse() {
        return null;
    }

    @Override
    public List<ScoredObject<Tree>> getBestPCFGParses() {
        ScoredObject<Tree> parse = new ScoredObject<Tree>(this.debinarized, this.finalState.score);
        return Collections.singletonList(parse);
    }

    @Override
    public boolean hasFactoredParse() {
        return false;
    }

    @Override
    public List<ScoredObject<Tree>> getKBestPCFGParses(int kbestPCFG) {
        ScoredObject<Tree> parse = new ScoredObject<Tree>(this.debinarized, this.finalState.score);
        return Collections.singletonList(parse);
    }

    @Override
    public List<ScoredObject<Tree>> getKGoodFactoredParses(int kbest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KBestViterbiParser getPCFGParser() {
        return null;
    }

    @Override
    public KBestViterbiParser getDependencyParser() {
        return null;
    }

    @Override
    public KBestViterbiParser getFactoredParser() {
        return null;
    }

    @Override
    public void setConstraints(List<ParserConstraint> constraints) {
        this.constraints = constraints;
    }

    @Override
    public boolean saidMemMessage() {
        return false;
    }

    @Override
    public boolean parseSucceeded() {
        return this.success;
    }

    @Override
    public boolean parseSkipped() {
        return false;
    }

    @Override
    public boolean parseFallback() {
        return false;
    }

    @Override
    public boolean parseNoMemory() {
        return false;
    }

    @Override
    public boolean parseUnparsable() {
        return this.unparsable;
    }

    @Override
    public List<? extends HasWord> originalSentence() {
        return this.originalSentence;
    }

    @Override
    public void restoreOriginalWords(Tree tree) {
        if (this.originalSentence == null || tree == null) {
            return;
        }
        List leaves = tree.getLeaves();
        if (leaves.size() != this.originalSentence.size()) {
            throw new IllegalStateException("originalWords and sentence of different sizes: " + this.originalSentence.size() + " vs. " + leaves.size() + "\n Orig: " + Sentence.listToString(this.originalSentence) + "\n Pars: " + Sentence.listToString(leaves));
        }
        Iterator<? extends HasWord> wordsIterator = this.originalSentence.iterator();
        for (Tree leaf : leaves) {
            leaf.setLabel((Label)((Object)wordsIterator.next()));
        }
    }
}

