/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading;

import edu.stanford.nlp.ie.machinereading.BasicEntityExtractor;
import edu.stanford.nlp.ie.machinereading.BasicRelationExtractor;
import edu.stanford.nlp.ie.machinereading.Extractor;
import edu.stanford.nlp.ie.machinereading.ExtractorMerger;
import edu.stanford.nlp.ie.machinereading.GenericDataSetReader;
import edu.stanford.nlp.ie.machinereading.MachineReadingProperties;
import edu.stanford.nlp.ie.machinereading.RelationFeatureFactory;
import edu.stanford.nlp.ie.machinereading.ResultsPrinter;
import edu.stanford.nlp.ie.machinereading.structure.AnnotationUtils;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ie.machinereading.structure.RelationMentionFactory;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class MachineReading {
    private String[] args;
    public GenericDataSetReader reader;
    public GenericDataSetReader auxReader;
    public Extractor entityExtractor;
    public Extractor relationExtractor;
    public Extractor relationExtractionPostProcessor;
    public Extractor eventExtractor;
    public Extractor consistencyChecker;
    protected boolean forceRetraining;
    public boolean forceParseSentences;
    private Pair<Annotation, Annotation>[] datasets;
    private Annotation[][] predictions;
    private Set<ResultsPrinter> entityResultsPrinterSet;
    private Set<ResultsPrinter> relationResultsPrinterSet;
    private Set<ResultsPrinter> eventResultsPrinterSet;
    public static final int ENTITY_LEVEL = 0;
    public static final int RELATION_LEVEL = 1;
    public static final int EVENT_LEVEL = 2;

    public static void main(String[] args) throws Exception {
        MachineReading mr = MachineReading.makeMachineReading(args);
        mr.run();
    }

    public static void setLoggerLevel(Level level) {
        MachineReading.setConsoleLevel(Level.FINEST);
        MachineReadingProperties.logger.setLevel(level);
    }

    public static void setConsoleLevel(Level level) {
        Logger topLogger = Logger.getLogger("");
        Handler consoleHandler = null;
        for (Handler handler : topLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            consoleHandler = handler;
            break;
        }
        if (consoleHandler == null) {
            consoleHandler = new ConsoleHandler();
            topLogger.addHandler(consoleHandler);
        }
        consoleHandler.setLevel(level);
        consoleHandler.setFormatter(new SimpleFormatter());
    }

    private MachineReading(String[] args) {
        this.args = args;
    }

    protected MachineReading() {
        this.args = new String[0];
    }

    public static MachineReading makeMachineReadingForAnnotation(GenericDataSetReader reader, Extractor entityExtractor, Extractor relationExtractor, Extractor eventExtractor, Extractor consistencyChecker, Extractor relationPostProcessor, boolean testRelationsUsingPredictedEntities, boolean verbose) {
        Level level;
        MachineReading mr = new MachineReading();
        mr.reader = reader;
        mr.auxReader = null;
        mr.entityResultsPrinterSet = new HashSet<ResultsPrinter>();
        mr.setRelationResultsPrinterSet(new HashSet<ResultsPrinter>());
        mr.predictions = new Annotation[3][1];
        mr.entityExtractor = entityExtractor;
        MachineReadingProperties.extractEntities = entityExtractor != null;
        mr.relationExtractor = relationExtractor;
        MachineReadingProperties.extractRelations = relationExtractor != null;
        MachineReadingProperties.testRelationsUsingPredictedEntities = testRelationsUsingPredictedEntities;
        mr.eventExtractor = eventExtractor;
        MachineReadingProperties.extractEvents = eventExtractor != null;
        mr.consistencyChecker = consistencyChecker;
        mr.relationExtractionPostProcessor = relationPostProcessor;
        Level level2 = level = verbose ? Level.FINEST : Level.SEVERE;
        if (entityExtractor != null) {
            entityExtractor.setLoggerLevel(level);
        }
        if (mr.relationExtractor != null) {
            mr.relationExtractor.setLoggerLevel(level);
        }
        if (mr.eventExtractor != null) {
            mr.eventExtractor.setLoggerLevel(level);
        }
        return mr;
    }

    public static MachineReading makeMachineReading(String[] args) throws IOException {
        MachineReading mr = new MachineReading(args);
        Execution.fillOptions(MachineReadingProperties.class, args);
        System.err.println("PERCENTAGE OF TRAIN: " + MachineReadingProperties.percentageOfTrain);
        Properties props = StringUtils.argsToProperties(args);
        if (props == null) {
            throw new RuntimeException("ERROR: failed to find Properties in the given arguments!");
        }
        String logLevel = props.getProperty("logLevel", "INFO");
        MachineReading.setLoggerLevel(Level.parse(logLevel.toUpperCase()));
        GenericDataSetReader reader = mr.makeReader(props);
        GenericDataSetReader auxReader = mr.makeAuxReader();
        Level readerLogLevel = Level.parse(MachineReadingProperties.readerLogLevel.toUpperCase());
        reader.setLoggerLevel(readerLogLevel);
        if (auxReader != null) {
            auxReader.setLoggerLevel(readerLogLevel);
        }
        System.err.println("The reader log level is set to " + readerLogLevel);
        StanfordCoreNLP pipe = new StanfordCoreNLP(props, false);
        reader.setProcessor(pipe);
        if (auxReader != null) {
            auxReader.setProcessor(pipe);
        }
        mr.makeResultsPrinters(args);
        return mr;
    }

    public List<String> run() throws Exception {
        boolean bl = this.forceRetraining = !MachineReadingProperties.loadModel;
        if (MachineReadingProperties.trainOnly) {
            this.forceRetraining = true;
        }
        ArrayList<String> retMsg = new ArrayList<String>();
        boolean haveSerializedEntityExtractor = this.serializedModelExists(MachineReadingProperties.serializedEntityExtractorPath);
        boolean haveSerializedRelationExtractor = this.serializedModelExists(MachineReadingProperties.serializedRelationExtractorPath);
        boolean haveSerializedEventExtractor = this.serializedModelExists(MachineReadingProperties.serializedEventExtractorPath);
        Annotation training = null;
        Annotation aux = null;
        if (MachineReadingProperties.extractEntities && !haveSerializedEntityExtractor || MachineReadingProperties.extractRelations && !haveSerializedRelationExtractor || MachineReadingProperties.extractEvents && !haveSerializedEventExtractor || this.forceRetraining || MachineReadingProperties.crossValidate) {
            training = this.loadOrMakeSerializedSentences(MachineReadingProperties.trainPath, this.reader, new File(MachineReadingProperties.serializedTrainingSentencesPath));
            if (this.auxReader != null) {
                MachineReadingProperties.logger.severe("Reading auxiliary dataset from " + MachineReadingProperties.auxDataPath + "...");
                aux = this.loadOrMakeSerializedSentences(MachineReadingProperties.auxDataPath, this.auxReader, new File(MachineReadingProperties.serializedAuxTrainingSentencesPath));
                MachineReadingProperties.logger.severe("Done reading auxiliary dataset.");
            }
        }
        Annotation testing = null;
        if (!MachineReadingProperties.trainOnly && !MachineReadingProperties.crossValidate) {
            File serializedTestSentences = new File(MachineReadingProperties.serializedTestSentencesPath);
            testing = this.loadOrMakeSerializedSentences(MachineReadingProperties.testPath, this.reader, serializedTestSentences);
        }
        this.makeDataSets(training, testing, aux);
        for (int partition = 0; partition < this.datasets.length; ++partition) {
            assert (this.datasets.length > partition);
            assert (this.datasets[partition] != null);
            assert (MachineReadingProperties.trainOnly || this.datasets[partition].second() != null);
            this.train(this.datasets[partition].first(), MachineReadingProperties.crossValidate ? partition : -1);
            if (MachineReadingProperties.trainOnly) continue;
            MachineReadingProperties.logger.info("annotating partition " + partition);
            this.annotate(this.datasets[partition].second(), MachineReadingProperties.crossValidate ? partition : -1);
        }
        if (!MachineReadingProperties.trainOnly) {
            Annotation gold = new Annotation("");
            for (Pair<Annotation, Annotation> dataset : this.datasets) {
                AnnotationUtils.addSentences(gold, (List)dataset.second().get(CoreAnnotations.SentencesAnnotation.class));
            }
            Annotation[] mergedPredictions = new Annotation[3];
            assert (this.predictions != null);
            for (int taskLevel = 0; taskLevel < mergedPredictions.length; ++taskLevel) {
                mergedPredictions[taskLevel] = new Annotation("");
                for (int fold = 0; fold < this.predictions[taskLevel].length; ++fold) {
                    if (this.predictions[taskLevel][fold] == null) continue;
                    AnnotationUtils.addSentences(mergedPredictions[taskLevel], (List)this.predictions[taskLevel][fold].get(CoreAnnotations.SentencesAnnotation.class));
                }
            }
            if (MachineReadingProperties.extractEntities && !this.entityResultsPrinterSet.isEmpty()) {
                retMsg.addAll(this.printTask("entity extraction", this.entityResultsPrinterSet, gold, mergedPredictions[0]));
            }
            if (MachineReadingProperties.extractRelations && !this.getRelationResultsPrinterSet().isEmpty()) {
                retMsg.addAll(this.printTask("relation extraction", this.getRelationResultsPrinterSet(), gold, mergedPredictions[1]));
            }
            if (MachineReadingProperties.extractEntities && MachineReadingProperties.serializedEntityExtractionResults != null) {
                IOUtils.writeObjectToFile((Object)mergedPredictions[0], MachineReadingProperties.serializedEntityExtractionResults);
            }
            if (MachineReadingProperties.extractRelations && MachineReadingProperties.serializedRelationExtractionResults != null) {
                IOUtils.writeObjectToFile((Object)mergedPredictions[1], MachineReadingProperties.serializedRelationExtractionResults);
            }
            if (MachineReadingProperties.extractEvents && MachineReadingProperties.serializedEventExtractionResults != null) {
                IOUtils.writeObjectToFile((Object)mergedPredictions[2], MachineReadingProperties.serializedEventExtractionResults);
            }
        }
        return retMsg;
    }

    protected List<String> printTask(String taskName, Set<ResultsPrinter> printers, Annotation gold, Annotation pred) {
        ArrayList<String> retMsg = new ArrayList<String>();
        for (ResultsPrinter rp : printers) {
            String msg = rp.printResults(gold, pred);
            retMsg.add(msg);
            MachineReadingProperties.logger.severe("Overall " + taskName + " results, using printer " + rp.getClass() + ":\n" + msg);
        }
        return retMsg;
    }

    protected void train(Annotation training, int partition) throws Exception {
        String msg;
        File modelFile;
        String modelName;
        if (MachineReadingProperties.extractEntities) {
            MachineReadingProperties.logger.info("Training entity extraction model(s)");
            if (partition != -1) {
                MachineReadingProperties.logger.info("In partition #" + partition);
            }
            modelName = MachineReadingProperties.serializedEntityExtractorPath;
            if (partition != -1) {
                modelName = modelName + "." + partition;
            }
            modelFile = new File(modelName);
            MachineReadingProperties.logger.fine("forceRetraining = " + this.forceRetraining + ", modelFile.exists = " + modelFile.exists());
            if (!this.forceRetraining && modelFile.exists()) {
                MachineReadingProperties.logger.info("Loading entity extraction model from " + modelName + " ...");
                this.entityExtractor = BasicEntityExtractor.load(modelName, MachineReadingProperties.entityClassifier, false);
            } else {
                MachineReadingProperties.logger.info("Training entity extraction model...");
                this.entityExtractor = MachineReading.makeEntityExtractor(MachineReadingProperties.entityClassifier, MachineReadingProperties.entityGazetteerPath);
                this.entityExtractor.train(training);
                MachineReadingProperties.logger.info("Serializing entity extraction model to " + modelName + " ...");
                this.entityExtractor.save(modelName);
            }
        }
        if (MachineReadingProperties.extractRelations) {
            MachineReadingProperties.logger.info("Training relation extraction model(s)");
            if (partition != -1) {
                MachineReadingProperties.logger.info("In partition #" + partition);
            }
            modelName = MachineReadingProperties.serializedRelationExtractorPath;
            if (partition != -1) {
                modelName = modelName + "." + partition;
            }
            Annotation predicted = null;
            if (MachineReadingProperties.useRelationExtractionModelMerging) {
                String[] modelNames = MachineReadingProperties.serializedRelationExtractorPath.split(",");
                if (partition != -1) {
                    int i = 0;
                    while (i < modelNames.length) {
                        int n = i++;
                        modelNames[n] = modelNames[n] + "." + partition;
                    }
                }
                this.relationExtractor = ExtractorMerger.buildRelationExtractorMerger(modelNames);
            } else if (!this.forceRetraining && new File(modelName).exists()) {
                MachineReadingProperties.logger.info("Loading relation extraction model from " + modelName + " ...");
                this.relationExtractor = BasicRelationExtractor.load(modelName);
            } else {
                RelationFeatureFactory rff = MachineReading.makeRelationFeatureFactory(MachineReadingProperties.relationFeatureFactoryClass, MachineReadingProperties.relationFeatures, MachineReadingProperties.doNotLexicalizeFirstArg);
                Execution.fillOptions((Object)rff, this.args);
                if (MachineReadingProperties.trainRelationsUsingPredictedEntities) {
                    assert (this.entityExtractor != null);
                    predicted = AnnotationUtils.deepMentionCopy(training);
                    this.entityExtractor.annotate(predicted);
                    for (ResultsPrinter rp : this.entityResultsPrinterSet) {
                        msg = rp.printResults(training, predicted);
                        MachineReadingProperties.logger.info("Training relation extraction using predicted entitities: entity scores using printer " + rp.getClass() + ":\n" + msg);
                    }
                    try {
                        MachineReading.changeGoldRelationArgsToPredicted(predicted);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                Annotation dataset = MachineReadingProperties.trainRelationsUsingPredictedEntities ? predicted : training;
                HashSet<String> relationsToSkip = new HashSet<String>(StringUtils.split(MachineReadingProperties.relationsToSkipDuringTraining, ","));
                ArrayList<List> backedUpRelations = new ArrayList<List>();
                if (relationsToSkip.size() > 0) {
                    for (CoreMap sent : (List)dataset.get(CoreAnnotations.SentencesAnnotation.class)) {
                        List relationMentions = (List)sent.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
                        backedUpRelations.add(relationMentions);
                    }
                    MachineReading.removeSkippableRelations(dataset, relationsToSkip);
                }
                this.relationExtractor = MachineReading.makeRelationExtractor(MachineReadingProperties.relationClassifier, rff, MachineReadingProperties.createUnrelatedRelations, MachineReading.makeRelationMentionFactory(MachineReadingProperties.relationMentionFactoryClass));
                Execution.fillOptions((Object)this.relationExtractor, this.args);
                MachineReadingProperties.logger.info("Training relation extraction model...");
                this.relationExtractor.train(dataset);
                MachineReadingProperties.logger.info("Serializing relation extraction model to " + modelName + " ...");
                this.relationExtractor.save(modelName);
                if (relationsToSkip.size() > 0) {
                    int sentenceIndex = 0;
                    for (CoreMap sentence : (List)dataset.get(CoreAnnotations.SentencesAnnotation.class)) {
                        List relationMentions = (List)backedUpRelations.get(sentenceIndex);
                        sentence.set(MachineReadingAnnotations.RelationMentionsAnnotation.class, relationMentions);
                        ++sentenceIndex;
                    }
                }
            }
        }
        if (MachineReadingProperties.extractEvents) {
            MachineReadingProperties.logger.info("Training event extraction model(s)");
            if (partition != -1) {
                MachineReadingProperties.logger.info("In partition #" + partition);
            }
            modelName = MachineReadingProperties.serializedEventExtractorPath;
            if (partition != -1) {
                modelName = modelName + "." + partition;
            }
            modelFile = new File(modelName);
            Annotation predicted = null;
            if (!this.forceRetraining && modelFile.exists()) {
                MachineReadingProperties.logger.info("Loading event extraction model from " + modelName + " ...");
                Method mstLoader = Class.forName("MSTBasedEventExtractor").getMethod("load", String.class);
                this.eventExtractor = (Extractor)mstLoader.invoke(null, modelName);
            } else {
                if (MachineReadingProperties.trainEventsUsingPredictedEntities) {
                    assert (this.entityExtractor != null);
                    predicted = AnnotationUtils.deepMentionCopy(training);
                    this.entityExtractor.annotate(predicted);
                    for (ResultsPrinter rp : this.entityResultsPrinterSet) {
                        msg = rp.printResults(training, predicted);
                        MachineReadingProperties.logger.info("Training event extraction using predicted entitities: entity scores using printer " + rp.getClass() + ":\n" + msg);
                    }
                }
                Constructor<?> mstConstructor = Class.forName("edu.stanford.nlp.ie.machinereading.MSTBasedEventExtractor").getConstructor(Boolean.TYPE);
                this.eventExtractor = (Extractor)mstConstructor.newInstance(MachineReadingProperties.trainEventsUsingPredictedEntities);
                MachineReadingProperties.logger.info("Training event extraction model...");
                if (MachineReadingProperties.trainRelationsUsingPredictedEntities) {
                    this.eventExtractor.train(predicted);
                } else {
                    this.eventExtractor.train(training);
                }
                MachineReadingProperties.logger.info("Serializing event extraction model to " + modelName + " ...");
                this.eventExtractor.save(modelName);
            }
        }
    }

    private static void removeSkippableRelations(Annotation dataset, Set<String> relationsToSkip) {
        if (relationsToSkip == null || relationsToSkip.size() == 0) {
            return;
        }
        for (CoreMap sent : (List)dataset.get(CoreAnnotations.SentencesAnnotation.class)) {
            List relationMentions = (List)sent.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
            if (relationMentions == null) continue;
            ArrayList<RelationMention> newRelationMentions = new ArrayList<RelationMention>();
            for (RelationMention rm : relationMentions) {
                if (relationsToSkip.contains(rm.getType())) continue;
                newRelationMentions.add(rm);
            }
            sent.set(MachineReadingAnnotations.RelationMentionsAnnotation.class, newRelationMentions);
        }
    }

    private static void changeGoldRelationArgsToPredicted(Annotation dataset) {
        for (CoreMap sent : (List)dataset.get(CoreAnnotations.SentencesAnnotation.class)) {
            List entityMentions = (List)sent.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
            List relationMentions = (List)sent.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
            ArrayList<RelationMention> newRels = new ArrayList<RelationMention>();
            for (RelationMention rm : relationMentions) {
                rm.setSentence(sent);
                if (rm.replaceGoldArgsWithPredicted(entityMentions)) {
                    MachineReadingProperties.logger.info("Successfully mapped all arguments in relation mention: " + rm);
                    newRels.add(rm);
                    continue;
                }
                MachineReadingProperties.logger.info("Dropped relation mention due to failed argument mapping: " + rm);
            }
            sent.set(MachineReadingAnnotations.RelationMentionsAnnotation.class, newRels);
            sent.set(MachineReadingAnnotations.EntityMentionsAnnotation.class, entityMentions);
        }
    }

    public Annotation annotate(Annotation testing) {
        return this.annotate(testing, -1);
    }

    protected Annotation annotate(Annotation testing, int partition) {
        String msg;
        Annotation predicted;
        int partitionIndex;
        int n = partitionIndex = partition != -1 ? partition : 0;
        if (MachineReadingProperties.extractEntities) {
            assert (this.entityExtractor != null);
            predicted = AnnotationUtils.deepMentionCopy(testing);
            this.entityExtractor.annotate(predicted);
            for (ResultsPrinter rp : this.entityResultsPrinterSet) {
                msg = rp.printResults(testing, predicted);
                MachineReadingProperties.logger.info("Entity extraction results " + (partition != -1 ? "for partition #" + partition : "") + " using printer " + rp.getClass() + ":\n" + msg);
            }
            this.predictions[0][partitionIndex] = predicted;
        }
        if (MachineReadingProperties.extractRelations) {
            assert (this.relationExtractor != null);
            predicted = MachineReadingProperties.testRelationsUsingPredictedEntities ? this.predictions[0][partitionIndex] : AnnotationUtils.deepMentionCopy(testing);
            this.assignSyntacticHeadToEntities(predicted);
            this.relationExtractor.annotate(predicted);
            if (this.relationExtractionPostProcessor == null) {
                this.relationExtractionPostProcessor = MachineReading.makeExtractor(MachineReadingProperties.relationExtractionPostProcessorClass);
            }
            if (this.relationExtractionPostProcessor != null) {
                MachineReadingProperties.logger.info("Using relation extraction post processor: " + MachineReadingProperties.relationExtractionPostProcessorClass);
                this.relationExtractionPostProcessor.annotate(predicted);
            }
            for (ResultsPrinter rp : this.getRelationResultsPrinterSet()) {
                msg = rp.printResults(testing, predicted);
                MachineReadingProperties.logger.info("Relation extraction results " + (partition != -1 ? "for partition #" + partition : "") + " using printer " + rp.getClass() + ":\n" + msg);
            }
            if (this.consistencyChecker == null) {
                this.consistencyChecker = MachineReading.makeExtractor(MachineReadingProperties.consistencyCheck);
            }
            if (this.consistencyChecker != null) {
                MachineReadingProperties.logger.info("Using consistency checker: " + MachineReadingProperties.consistencyCheck);
                this.consistencyChecker.annotate(predicted);
                for (ResultsPrinter rp : this.entityResultsPrinterSet) {
                    msg = rp.printResults(testing, predicted);
                    MachineReadingProperties.logger.info("Entity extraction results AFTER consistency checks " + (partition != -1 ? "for partition #" + partition : "") + " using printer " + rp.getClass() + ":\n" + msg);
                }
                for (ResultsPrinter rp : this.getRelationResultsPrinterSet()) {
                    msg = rp.printResults(testing, predicted);
                    MachineReadingProperties.logger.info("Relation extraction results AFTER consistency checks " + (partition != -1 ? "for partition #" + partition : "") + " using printer " + rp.getClass() + ":\n" + msg);
                }
            }
            this.predictions[1][partitionIndex] = predicted;
        }
        return this.predictions[1][partitionIndex];
    }

    private void assignSyntacticHeadToEntities(Annotation corpus) {
        assert (corpus != null);
        assert (corpus.get(CoreAnnotations.SentencesAnnotation.class) != null);
        for (CoreMap sent : (List)corpus.get(CoreAnnotations.SentencesAnnotation.class)) {
            List tokens = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
            assert (tokens != null);
            Tree tree = (Tree)sent.get(TreeCoreAnnotations.TreeAnnotation.class);
            if (MachineReadingProperties.forceGenerationOfIndexSpans) {
                tree.indexSpans(0);
            }
            assert (tree != null);
            if (sent.get(MachineReadingAnnotations.EntityMentionsAnnotation.class) == null) continue;
            for (EntityMention e : (List)sent.get(MachineReadingAnnotations.EntityMentionsAnnotation.class)) {
                this.reader.assignSyntacticHead(e, tree, tokens, true);
            }
        }
    }

    public static Extractor makeExtractor(Class<Extractor> extractorClass) {
        Extractor ex;
        if (extractorClass == null) {
            return null;
        }
        try {
            ex = extractorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ex;
    }

    protected void makeDataSets(Annotation training, Annotation testing, Annotation auxDataset) {
        if (!MachineReadingProperties.crossValidate) {
            this.datasets = new Pair[1];
            Annotation trainingEnhanced = training;
            if (auxDataset != null) {
                trainingEnhanced = new Annotation((String)training.get(CoreAnnotations.TextAnnotation.class));
                for (int i = 0; i < AnnotationUtils.sentenceCount(training); ++i) {
                    AnnotationUtils.addSentence(trainingEnhanced, AnnotationUtils.getSentence(training, i));
                }
                for (int ind = 0; ind < AnnotationUtils.sentenceCount(auxDataset); ++ind) {
                    AnnotationUtils.addSentence(trainingEnhanced, AnnotationUtils.getSentence(auxDataset, ind));
                }
            }
            this.datasets[0] = new Pair<Annotation, Annotation>(trainingEnhanced, testing);
            this.predictions = new Annotation[3][1];
        } else {
            assert (MachineReadingProperties.kfold > 1);
            this.datasets = new Pair[MachineReadingProperties.kfold];
            AnnotationUtils.shuffleSentences(training);
            for (int partition = 0; partition < MachineReadingProperties.kfold; ++partition) {
                int begin = AnnotationUtils.sentenceCount(training) * partition / MachineReadingProperties.kfold;
                int end = AnnotationUtils.sentenceCount(training) * (partition + 1) / MachineReadingProperties.kfold;
                MachineReadingProperties.logger.info("Creating partition #" + partition + " using offsets [" + begin + ", " + end + ") out of " + AnnotationUtils.sentenceCount(training));
                Annotation partitionTrain = new Annotation("");
                Annotation partitionTest = new Annotation("");
                for (int i = 0; i < AnnotationUtils.sentenceCount(training); ++i) {
                    if (i < begin) {
                        AnnotationUtils.addSentence(partitionTrain, AnnotationUtils.getSentence(training, i));
                        continue;
                    }
                    if (i < end) {
                        AnnotationUtils.addSentence(partitionTest, AnnotationUtils.getSentence(training, i));
                        continue;
                    }
                    AnnotationUtils.addSentence(partitionTrain, AnnotationUtils.getSentence(training, i));
                }
                if (auxDataset != null) {
                    for (int ind = 0; ind < AnnotationUtils.sentenceCount(auxDataset); ++ind) {
                        AnnotationUtils.addSentence(partitionTrain, AnnotationUtils.getSentence(auxDataset, ind));
                    }
                }
                this.datasets[partition] = new Pair<Annotation, Annotation>(partitionTrain, partitionTest);
            }
            this.predictions = new Annotation[3][MachineReadingProperties.kfold];
        }
    }

    static Annotation keepPercentage(Annotation corpus, double percentage) {
        System.err.println("Using percentage of train: " + percentage);
        Annotation smaller = new Annotation("");
        ArrayList sents = new ArrayList();
        List fullSents = (List)corpus.get(CoreAnnotations.SentencesAnnotation.class);
        double smallSize = (double)fullSents.size() * percentage;
        int i = 0;
        while ((double)i < smallSize) {
            sents.add(fullSents.get(i));
            ++i;
        }
        System.err.println("TRAIN corpus size reduced from " + fullSents.size() + " to " + sents.size());
        smaller.set(CoreAnnotations.SentencesAnnotation.class, sents);
        return smaller;
    }

    protected boolean serializedModelExists(String prefix) {
        if (!MachineReadingProperties.crossValidate) {
            File f = new File(prefix);
            return f.exists();
        }
        for (int i = 0; i < MachineReadingProperties.kfold; ++i) {
            File f = new File(prefix + "." + Integer.toString(i));
            if (f.exists()) continue;
            return false;
        }
        return true;
    }

    private void makeResultsPrinters(String[] args) {
        this.entityResultsPrinterSet = this.makeResultsPrinters(MachineReadingProperties.entityResultsPrinters, args);
        this.setRelationResultsPrinterSet(this.makeResultsPrinters(MachineReadingProperties.relationResultsPrinters, args));
        this.eventResultsPrinterSet = this.makeResultsPrinters(MachineReadingProperties.eventResultsPrinters, args);
    }

    private Set<ResultsPrinter> makeResultsPrinters(String classes, String[] args) {
        MachineReadingProperties.logger.info("Making result printers from " + classes);
        String[] printerClassNames = classes.trim().split(",\\s*");
        HashSet<ResultsPrinter> printers = new HashSet<ResultsPrinter>();
        for (String printerClassName : printerClassNames) {
            if (printerClassName.length() == 0) continue;
            try {
                ResultsPrinter rp = (ResultsPrinter)Class.forName(printerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                printers.add(rp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return printers;
    }

    private GenericDataSetReader makeReader(Properties props) {
        try {
            if (this.reader == null) {
                try {
                    this.reader = MachineReadingProperties.datasetReaderClass.getConstructor(Properties.class).newInstance(props);
                }
                catch (NoSuchMethodException e) {
                    this.reader = MachineReadingProperties.datasetReaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.reader.setUseNewHeadFinder(MachineReadingProperties.useNewHeadFinder);
        return this.reader;
    }

    private GenericDataSetReader makeAuxReader() {
        try {
            if (this.auxReader == null && MachineReadingProperties.datasetAuxReaderClass != null) {
                this.auxReader = MachineReadingProperties.datasetAuxReaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.auxReader;
    }

    public static Extractor makeEntityExtractor(Class<? extends BasicEntityExtractor> entityExtractorClass, String gazetteerPath) {
        BasicEntityExtractor ex;
        if (entityExtractorClass == null) {
            return null;
        }
        try {
            ex = entityExtractorClass.getConstructor(String.class).newInstance(gazetteerPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ex;
    }

    public static Extractor makeRelationExtractor(Class<? extends BasicRelationExtractor> relationExtractorClass, RelationFeatureFactory featureFac, boolean createUnrelatedRelations, RelationMentionFactory factory) {
        BasicRelationExtractor ex;
        if (relationExtractorClass == null) {
            return null;
        }
        try {
            ex = relationExtractorClass.getConstructor(RelationFeatureFactory.class, Boolean.class, RelationMentionFactory.class).newInstance(featureFac, createUnrelatedRelations, factory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ex;
    }

    public static RelationFeatureFactory makeRelationFeatureFactory(Class<? extends RelationFeatureFactory> relationFeatureFactoryClass, String relationFeatureList, boolean doNotLexicalizeFirstArg) {
        RelationFeatureFactory rff;
        if (relationFeatureList == null || relationFeatureFactoryClass == null) {
            return null;
        }
        Object[] featureList = new Object[]{relationFeatureList.trim().split(",\\s*")};
        try {
            rff = relationFeatureFactoryClass.getConstructor(String[].class).newInstance(featureList);
            rff.setDoNotLexicalizeFirstArgument(doNotLexicalizeFirstArg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rff;
    }

    public static RelationMentionFactory makeRelationMentionFactory(Class<RelationMentionFactory> relationMentionFactoryClass) {
        RelationMentionFactory rmf;
        try {
            rmf = relationMentionFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rmf;
    }

    protected Annotation loadOrMakeSerializedSentences(String sentencesPath, GenericDataSetReader reader, File serializedSentences) throws IOException, ClassNotFoundException {
        Annotation corpusSentences;
        if (MachineReadingProperties.serializeCorpora && serializedSentences.exists() && !this.forceParseSentences) {
            MachineReadingProperties.logger.info("Loaded serialized sentences from " + serializedSentences.getAbsolutePath() + "...");
            corpusSentences = (Annotation)IOUtils.readObjectFromFile(serializedSentences);
            MachineReadingProperties.logger.info("Done. Loaded " + ((List)corpusSentences.get(CoreAnnotations.SentencesAnnotation.class)).size() + " sentences.");
        } else {
            MachineReadingProperties.logger.info("Parsing corpus sentences...");
            if (MachineReadingProperties.serializeCorpora) {
                MachineReadingProperties.logger.info("These sentences will be serialized to " + serializedSentences.getAbsolutePath());
            }
            corpusSentences = reader.parse(sentencesPath);
            MachineReadingProperties.logger.info("Done. Parsed " + AnnotationUtils.sentenceCount(corpusSentences) + " sentences.");
            if (MachineReadingProperties.serializeCorpora) {
                MachineReadingProperties.logger.info("Serializing parsed sentences to " + serializedSentences.getAbsolutePath() + "...");
                IOUtils.writeObjectToFile((Object)corpusSentences, serializedSentences);
                MachineReadingProperties.logger.info("Done. Serialized " + AnnotationUtils.sentenceCount(corpusSentences) + " sentences.");
            }
        }
        return corpusSentences;
    }

    public void setExtractEntities(boolean extractEntities) {
        MachineReadingProperties.extractEntities = extractEntities;
    }

    public void setExtractRelations(boolean extractRelations) {
        MachineReadingProperties.extractRelations = extractRelations;
    }

    public void setExtractEvents(boolean extractEvents) {
        MachineReadingProperties.extractEvents = extractEvents;
    }

    public void setForceParseSentences(boolean forceParseSentences) {
        this.forceParseSentences = forceParseSentences;
    }

    public void setDatasets(Pair<Annotation, Annotation>[] datasets) {
        this.datasets = datasets;
    }

    public Pair<Annotation, Annotation>[] getDatasets() {
        return this.datasets;
    }

    public void setPredictions(Annotation[][] predictions) {
        this.predictions = predictions;
    }

    public Annotation[][] getPredictions() {
        return this.predictions;
    }

    public void setReader(GenericDataSetReader reader) {
        this.reader = reader;
    }

    public GenericDataSetReader getReader() {
        return this.reader;
    }

    public void setAuxReader(GenericDataSetReader auxReader) {
        this.auxReader = auxReader;
    }

    public GenericDataSetReader getAuxReader() {
        return this.auxReader;
    }

    public void setEntityResultsPrinterSet(Set<ResultsPrinter> entityResultsPrinterSet) {
        this.entityResultsPrinterSet = entityResultsPrinterSet;
    }

    public Set<ResultsPrinter> getEntityResultsPrinterSet() {
        return this.entityResultsPrinterSet;
    }

    public void setRelationResultsPrinterSet(Set<ResultsPrinter> relationResultsPrinterSet) {
        this.relationResultsPrinterSet = relationResultsPrinterSet;
    }

    public Set<ResultsPrinter> getRelationResultsPrinterSet() {
        return this.relationResultsPrinterSet;
    }
}

