/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CorefMentionFinder;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.MultiTokenTag;
import edu.stanford.nlp.parser.common.ParserAnnotations;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class RuleBasedCorefMentionFinder
implements CorefMentionFinder {
    protected boolean assignIds = true;
    private final HeadFinder headFinder;
    protected Annotator parserProcessor;
    private final boolean allowReparsing;
    private static final TregexPattern npOrPrpMentionPattern = TregexPattern.compile("/^(?:NP|PRP)/");
    private static final TregexPattern enumerationsMentionPattern = TregexPattern.compile("NP < (/^(?:NP|NNP|NML)/=m1 $.. (/^CC|,/ $.. /^(?:NP|NNP|NML)/=m2))");
    private static final TregexPattern[] pleonasticPatterns = RuleBasedCorefMentionFinder.getPleonasticPatterns();

    public RuleBasedCorefMentionFinder() {
        this(true);
    }

    public RuleBasedCorefMentionFinder(boolean allowReparsing) {
        SieveCoreferenceSystem.logger.fine("Using SEMANTIC HEAD FINDER!!!!!!!!!!!!!!!!!!!");
        this.headFinder = new SemanticHeadFinder();
        this.allowReparsing = allowReparsing;
    }

    public List<List<Mention>> filterPredictedMentions(List<List<Mention>> allGoldMentions, Annotation doc, Dictionaries dict) {
        ArrayList<List<Mention>> predictedMentions = new ArrayList<List<Mention>>();
        for (int i = 0; i < allGoldMentions.size(); ++i) {
            CoreMap s = (CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
            List<Mention> goldMentions = allGoldMentions.get(i);
            ArrayList<Mention> mentions = new ArrayList<Mention>();
            predictedMentions.add(mentions);
            mentions.addAll(goldMentions);
            this.findHead(s, mentions);
            Set<IntPair> mentionSpanSet = Generics.newHashSet();
            Set<IntPair> namedEntitySpanSet = Generics.newHashSet();
            for (Mention m : mentions) {
                mentionSpanSet.add(new IntPair(m.startIndex, m.endIndex));
                if (((String)m.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("O")) continue;
                namedEntitySpanSet.add(new IntPair(m.startIndex, m.endIndex));
            }
            RuleBasedCorefMentionFinder.setBarePlural(mentions);
            RuleBasedCorefMentionFinder.removeSpuriousMentions(s, mentions, dict);
        }
        return predictedMentions;
    }

    @Override
    public List<List<Mention>> extractPredictedMentions(Annotation doc, int maxID, Dictionaries dict) {
        ArrayList<List<Mention>> predictedMentions = new ArrayList<List<Mention>>();
        for (CoreMap s : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
            ArrayList<Mention> mentions = new ArrayList<Mention>();
            predictedMentions.add(mentions);
            Set<IntPair> mentionSpanSet = Generics.newHashSet();
            Set<IntPair> namedEntitySpanSet = Generics.newHashSet();
            RuleBasedCorefMentionFinder.extractPremarkedEntityMentions(s, mentions, mentionSpanSet, namedEntitySpanSet);
            RuleBasedCorefMentionFinder.extractNamedEntityMentions(s, mentions, mentionSpanSet, namedEntitySpanSet);
            RuleBasedCorefMentionFinder.extractNPorPRP(s, mentions, mentionSpanSet, namedEntitySpanSet);
            RuleBasedCorefMentionFinder.extractEnumerations(s, mentions, mentionSpanSet, namedEntitySpanSet);
            this.findHead(s, mentions);
            RuleBasedCorefMentionFinder.setBarePlural(mentions);
            RuleBasedCorefMentionFinder.removeSpuriousMentions(s, mentions, dict);
        }
        if (this.assignIds) {
            RuleBasedCorefMentionFinder.assignMentionIDs(predictedMentions, maxID);
        }
        return predictedMentions;
    }

    protected static void assignMentionIDs(List<List<Mention>> predictedMentions, int maxID) {
        for (List<Mention> mentions : predictedMentions) {
            for (Mention m : mentions) {
                m.mentionID = ++maxID;
            }
        }
    }

    protected static void setBarePlural(List<Mention> mentions) {
        for (Mention m : mentions) {
            String pos = (String)m.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            if (m.originalSpan.size() != 1 || !pos.equals("NNS")) continue;
            m.generic = true;
        }
    }

    protected static void extractPremarkedEntityMentions(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph dependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class);
        int beginIndex = -1;
        for (CoreLabel w : sent) {
            MultiTokenTag t = (MultiTokenTag)w.get(CoreAnnotations.MentionTokenAnnotation.class);
            if (t == null) continue;
            if (t.isStart()) {
                beginIndex = (Integer)w.get(CoreAnnotations.IndexAnnotation.class) - 1;
            }
            if (!t.isEnd()) continue;
            int endIndex = (Integer)w.get(CoreAnnotations.IndexAnnotation.class);
            if (beginIndex >= 0) {
                IntPair mSpan = new IntPair(beginIndex, endIndex);
                int dummyMentionId = -1;
                Mention m = new Mention(dummyMentionId, beginIndex, endIndex, dependency, new ArrayList<CoreLabel>(sent.subList(beginIndex, endIndex)));
                mentions.add(m);
                mentionSpanSet.add(mSpan);
                beginIndex = -1;
                continue;
            }
            SieveCoreferenceSystem.logger.warning("Start of marked mention not found in sentence: " + t + " at tokenIndex=" + ((Integer)w.get(CoreAnnotations.IndexAnnotation.class) - 1) + " for " + (String)s.get(CoreAnnotations.TextAnnotation.class));
        }
    }

    protected static void extractNamedEntityMentions(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        IntPair mSpan;
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph dependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class);
        String preNE = "O";
        int beginIndex = -1;
        for (CoreLabel w : sent) {
            String nerString = (String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (nerString.equals(preNE)) continue;
            int endIndex = (Integer)w.get(CoreAnnotations.IndexAnnotation.class) - 1;
            if (!preNE.matches("O|QUANTITY|CARDINAL|PERCENT|DATE|DURATION|TIME|SET")) {
                if (((String)w.get(CoreAnnotations.TextAnnotation.class)).equals("'s")) {
                    ++endIndex;
                }
                IntPair mSpan2 = new IntPair(beginIndex, endIndex);
                if (beginIndex < endIndex && !mentionSpanSet.contains(mSpan2)) {
                    int dummyMentionId = -1;
                    Mention m = new Mention(dummyMentionId, beginIndex, endIndex, dependency, new ArrayList<CoreLabel>(sent.subList(beginIndex, endIndex)));
                    mentions.add(m);
                    mentionSpanSet.add(mSpan2);
                    namedEntitySpanSet.add(mSpan2);
                }
            }
            beginIndex = endIndex;
            preNE = nerString;
        }
        if (!preNE.matches("O|QUANTITY|CARDINAL|PERCENT|DATE|DURATION|TIME|SET") && !mentionSpanSet.contains(mSpan = new IntPair(beginIndex, sent.size()))) {
            int dummyMentionId = -1;
            Mention m = new Mention(dummyMentionId, beginIndex, sent.size(), dependency, new ArrayList<CoreLabel>(sent.subList(beginIndex, sent.size())));
            mentions.add(m);
            mentionSpanSet.add(mSpan);
            namedEntitySpanSet.add(mSpan);
        }
    }

    protected static void extractNPorPRP(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        Tree tree = (Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class);
        tree.indexLeaves();
        SemanticGraph dependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class);
        TregexPattern tgrepPattern = npOrPrpMentionPattern;
        TregexMatcher matcher = tgrepPattern.matcher(tree);
        while (matcher.find()) {
            IntPair mSpan;
            Tree t = matcher.getMatch();
            List mLeaves = t.getLeaves();
            int beginIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(0)).label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
            int endIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(mLeaves.size() - 1)).label()).get(CoreAnnotations.IndexAnnotation.class);
            if (",".equals(((CoreLabel)sent.get(endIdx - 1)).word())) {
                --endIdx;
            }
            if (mentionSpanSet.contains(mSpan = new IntPair(beginIdx, endIdx)) || RuleBasedCorefMentionFinder.insideNE(mSpan, namedEntitySpanSet)) continue;
            int dummyMentionId = -1;
            Mention m = new Mention(dummyMentionId, beginIdx, endIdx, dependency, new ArrayList<CoreLabel>(sent.subList(beginIdx, endIdx)), t);
            mentions.add(m);
            mentionSpanSet.add(mSpan);
        }
    }

    protected static void extractEnumerations(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        Tree tree = (Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class);
        SemanticGraph dependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class);
        TregexPattern tgrepPattern = enumerationsMentionPattern;
        TregexMatcher matcher = tgrepPattern.matcher(tree);
        Map<IntPair, Tree> spanToMentionSubTree = Generics.newHashMap();
        while (matcher.find()) {
            matcher.getMatch();
            Tree m1 = matcher.getNode("m1");
            Tree m2 = matcher.getNode("m2");
            List mLeaves = m1.getLeaves();
            int beginIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(0)).label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
            int endIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(mLeaves.size() - 1)).label()).get(CoreAnnotations.IndexAnnotation.class);
            spanToMentionSubTree.put(new IntPair(beginIdx, endIdx), m1);
            mLeaves = m2.getLeaves();
            beginIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(0)).label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
            endIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(mLeaves.size() - 1)).label()).get(CoreAnnotations.IndexAnnotation.class);
            spanToMentionSubTree.put(new IntPair(beginIdx, endIdx), m2);
        }
        for (IntPair mSpan : spanToMentionSubTree.keySet()) {
            if (mentionSpanSet.contains(mSpan) || RuleBasedCorefMentionFinder.insideNE(mSpan, namedEntitySpanSet)) continue;
            int dummyMentionId = -1;
            Mention m = new Mention(dummyMentionId, mSpan.get(0), mSpan.get(1), dependency, new ArrayList<CoreLabel>(sent.subList(mSpan.get(0), mSpan.get(1))), (Tree)spanToMentionSubTree.get(mSpan));
            mentions.add(m);
            mentionSpanSet.add(mSpan);
        }
    }

    private static boolean insideNE(IntPair mSpan, Set<IntPair> namedEntitySpanSet) {
        for (IntPair span : namedEntitySpanSet) {
            if (span.get(0) > mSpan.get(0) || mSpan.get(1) > span.get(1)) continue;
            return true;
        }
        return false;
    }

    protected void findHead(CoreMap s, List<Mention> mentions) {
        Tree tree = (Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class);
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        tree.indexSpans(0);
        for (Mention m : mentions) {
            Tree head = this.findSyntacticHead(m, tree, sent);
            m.headIndex = (Integer)((CoreLabel)head.label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
            m.headWord = (CoreLabel)sent.get(m.headIndex);
            m.headString = ((String)m.headWord.get(CoreAnnotations.TextAnnotation.class)).toLowerCase(Locale.ENGLISH);
            int start = m.headIndex - m.startIndex;
            if (start >= 0 && start < m.originalSpan.size()) continue;
            SieveCoreferenceSystem.logger.warning("Invalid index for head " + start + "=" + m.headIndex + "-" + m.startIndex + ": originalSpan=[" + StringUtils.joinWords(m.originalSpan, " ") + "], head=" + m.headWord);
            SieveCoreferenceSystem.logger.warning("Setting head string to entire mention");
            m.headIndex = m.startIndex;
            m.headWord = m.originalSpan.size() > 0 ? m.originalSpan.get(0) : (CoreLabel)sent.get(m.startIndex);
            m.headString = m.originalSpan.toString();
        }
    }

    protected Tree findSyntacticHead(Mention m, Tree root, List<CoreLabel> tokens) {
        int index;
        Tree head;
        Tree exactMatch;
        String lastWord;
        int endIdx = m.endIndex;
        if (m.originalSpan.size() > 0 && ((lastWord = (String)m.originalSpan.get(m.originalSpan.size() - 1).get(CoreAnnotations.TextAnnotation.class)).equals("'s") || lastWord.equals("'")) && m.originalSpan.size() != 1) {
            --endIdx;
        }
        if ((exactMatch = RuleBasedCorefMentionFinder.findTreeWithSpan(root, m.startIndex, endIdx)) != null) {
            return this.safeHead(exactMatch, endIdx);
        }
        if (this.allowReparsing) {
            int approximateness = 0;
            ArrayList<CoreLabel> extentTokens = new ArrayList<CoreLabel>();
            extentTokens.add(RuleBasedCorefMentionFinder.initCoreLabel("It"));
            extentTokens.add(RuleBasedCorefMentionFinder.initCoreLabel("was"));
            int ADDED_WORDS = 2;
            for (int i = m.startIndex; i < endIdx; ++i) {
                CoreLabel label = tokens.get(i);
                if (!"-".equals(label.word())) {
                    extentTokens.add((CoreLabel)label.labelFactory().newLabel(label));
                    continue;
                }
                ++approximateness;
            }
            extentTokens.add(RuleBasedCorefMentionFinder.initCoreLabel("."));
            ParserConstraint constraint = new ParserConstraint(2, extentTokens.size() - 1, Pattern.compile(".*"));
            List<ParserConstraint> constraints = Collections.singletonList(constraint);
            Tree tree = this.parse(extentTokens, constraints);
            RuleBasedCorefMentionFinder.convertToCoreLabels(tree);
            tree.indexSpans(m.startIndex - 2);
            Tree subtree = RuleBasedCorefMentionFinder.findPartialSpan(tree, m.startIndex);
            Tree extentHead = this.safeHead(subtree, endIdx);
            assert (extentHead != null);
            CoreLabel l = (CoreLabel)extentHead.label();
            Tree realHead = RuleBasedCorefMentionFinder.funkyFindLeafWithApproximateSpan(root, l.value(), (Integer)l.get(CoreAnnotations.BeginIndexAnnotation.class), approximateness);
            assert (realHead != null);
            return realHead;
        }
        Tree wordMatch = RuleBasedCorefMentionFinder.findTreeWithSmallestSpan(root, m.startIndex, endIdx);
        if (wordMatch != null && (head = this.safeHead(wordMatch, endIdx)) != null && (index = (Integer)((CoreLabel)head.label()).get(CoreAnnotations.IndexAnnotation.class) - 1) >= m.startIndex && index < endIdx) {
            return head;
        }
        int lastNounIdx = endIdx - 1;
        for (int i = m.startIndex; i < m.endIndex; ++i) {
            if (tokens.get(i).tag().startsWith("N")) {
                lastNounIdx = i;
                continue;
            }
            if (tokens.get(i).tag().startsWith("W")) break;
        }
        List leaves = root.getLeaves();
        Tree endLeaf = (Tree)leaves.get(lastNounIdx);
        return endLeaf;
    }

    private static Tree findPartialSpan(Tree root, int start) {
        CoreLabel label = (CoreLabel)root.label();
        int startIndex = (Integer)label.get(CoreAnnotations.BeginIndexAnnotation.class);
        if (startIndex == start) {
            return root;
        }
        for (Tree kid : root.children()) {
            CoreLabel kidLabel = (CoreLabel)kid.label();
            int kidStart = (Integer)kidLabel.get(CoreAnnotations.BeginIndexAnnotation.class);
            int kidEnd = (Integer)kidLabel.get(CoreAnnotations.EndIndexAnnotation.class);
            if (kidStart > start || kidEnd <= start) continue;
            return RuleBasedCorefMentionFinder.findPartialSpan(kid, start);
        }
        throw new RuntimeException("Shouldn't happen: " + start + " " + root);
    }

    private static Tree funkyFindLeafWithApproximateSpan(Tree root, String token, int index, int approximateness) {
        List leaves = root.getLeaves();
        for (Tree leaf : leaves) {
            CoreLabel label = (CoreLabel)CoreLabel.class.cast(leaf.label());
            Integer indexInteger = (Integer)label.get(CoreAnnotations.IndexAnnotation.class);
            if (indexInteger == null) continue;
            int ind = indexInteger - 1;
            if (!token.equals(leaf.value()) || ind < index || ind > index + approximateness) continue;
            return leaf;
        }
        SieveCoreferenceSystem.logger.warning("RuleBasedCorefMentionFinder: Failed to find head token:\nTree is: " + root + "\n" + "token = |" + token + "|" + index + "|, approx=" + approximateness);
        for (Tree leaf : leaves) {
            if (!token.equals(leaf.value())) continue;
            return leaf;
        }
        int fallback = Math.max(0, leaves.size() - 2);
        SieveCoreferenceSystem.logger.warning("RuleBasedCorefMentionFinder: Last resort: returning as head: " + leaves.get(fallback));
        return (Tree)leaves.get(fallback);
    }

    private static CoreLabel initCoreLabel(String token) {
        CoreLabel label = new CoreLabel();
        label.set(CoreAnnotations.TextAnnotation.class, token);
        label.set(CoreAnnotations.ValueAnnotation.class, token);
        return label;
    }

    private Tree parse(List<CoreLabel> tokens) {
        return this.parse(tokens, null);
    }

    private Tree parse(List<CoreLabel> tokens, List<ParserConstraint> constraints) {
        Annotation sent = new Annotation("");
        sent.set(CoreAnnotations.TokensAnnotation.class, tokens);
        sent.set(ParserAnnotations.ConstraintAnnotation.class, constraints);
        Annotation doc = new Annotation("");
        List sents = new ArrayList<Annotation>(1);
        sents.add(sent);
        doc.set(CoreAnnotations.SentencesAnnotation.class, sents);
        this.getParser().annotate(doc);
        sents = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        return (Tree)((CoreMap)sents.get(0)).get(TreeCoreAnnotations.TreeAnnotation.class);
    }

    private Annotator getParser() {
        if (this.parserProcessor == null) {
            Annotator parser = StanfordCoreNLP.getExistingAnnotator("parse");
            if (parser == null) {
                throw new AssertionError((Object)"Failed to get parser - this should not be possible");
            }
            if (parser.requires().contains(Annotator.POS_REQUIREMENT)) {
                Annotator tagger = StanfordCoreNLP.getExistingAnnotator("pos");
                if (tagger == null) {
                    throw new AssertionError((Object)"Parser required tagger, but failed to find the pos annotator");
                }
                ArrayList<Annotator> annotators = Generics.newArrayList();
                annotators.add(tagger);
                annotators.add(parser);
                this.parserProcessor = new AnnotationPipeline(annotators);
            } else {
                this.parserProcessor = parser;
            }
        }
        return this.parserProcessor;
    }

    private static void convertToCoreLabels(Tree tree) {
        Label l = tree.label();
        if (!(l instanceof CoreLabel)) {
            CoreLabel cl = new CoreLabel();
            cl.setValue(l.value());
            tree.setLabel(cl);
        }
        for (Tree kid : tree.children()) {
            RuleBasedCorefMentionFinder.convertToCoreLabels(kid);
        }
    }

    private Tree safeHead(Tree top, int endIndex) {
        int headIndex;
        Integer headIndexInteger;
        Tree head = top.headTerminal(this.headFinder);
        if (head != null && (headIndexInteger = (Integer)((CoreLabel)head.label()).get(CoreAnnotations.IndexAnnotation.class)) != null && (headIndex = headIndexInteger - 1) < endIndex) {
            return head;
        }
        List leaves = top.getLeaves();
        for (int candidate = leaves.size() - 1; candidate >= 0; --candidate) {
            int headIndex2;
            head = (Tree)leaves.get(candidate);
            Integer headIndexInteger2 = (Integer)((CoreLabel)head.label()).get(CoreAnnotations.IndexAnnotation.class);
            if (headIndexInteger2 == null || (headIndex2 = headIndexInteger2 - 1) >= endIndex) continue;
            return head;
        }
        return top;
    }

    static Tree findTreeWithSmallestSpan(Tree tree, int start, int end) {
        List leaves = tree.getLeaves();
        Tree startLeaf = (Tree)leaves.get(start);
        Tree endLeaf = (Tree)leaves.get(end - 1);
        return Trees.getLowestCommonAncestor(Arrays.asList(startLeaf, endLeaf), tree);
    }

    private static Tree findTreeWithSpan(Tree tree, int start, int end) {
        CoreLabel l = (CoreLabel)tree.label();
        if (l != null && l.has(CoreAnnotations.BeginIndexAnnotation.class) && l.has(CoreAnnotations.EndIndexAnnotation.class)) {
            int myStart = (Integer)l.get(CoreAnnotations.BeginIndexAnnotation.class);
            int myEnd = (Integer)l.get(CoreAnnotations.EndIndexAnnotation.class);
            if (start == myStart && end == myEnd) {
                return tree;
            }
            if (end < myStart) {
                return null;
            }
            if (start >= myEnd) {
                return null;
            }
        }
        for (Tree kid : tree.children()) {
            Tree ret;
            if (kid == null || (ret = RuleBasedCorefMentionFinder.findTreeWithSpan(kid, start, end)) == null) continue;
            return ret;
        }
        return null;
    }

    protected static void removeSpuriousMentions(CoreMap s, List<Mention> mentions, Dictionaries dict) {
        Tree tree = (Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class);
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        Set<Mention> remove = Generics.newHashSet();
        for (Mention m : mentions) {
            String headPOS = (String)m.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            String headNE = (String)m.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (RuleBasedCorefMentionFinder.isPleonastic(m, tree)) {
                remove.add(m);
            }
            if (dict.nonWords.contains(m.headString)) {
                remove.add(m);
            }
            if (m.originalSpan.size() > 0 && dict.quantifiers.contains(((String)m.originalSpan.get(0).get(CoreAnnotations.TextAnnotation.class)).toLowerCase(Locale.ENGLISH))) {
                remove.add(m);
            }
            if (RuleBasedCorefMentionFinder.partitiveRule(m, sent, dict)) {
                remove.add(m);
            }
            if (headPOS.equals("NN") && !dict.temporals.contains(m.headString) && (m.originalSpan.size() == 1 || ((String)m.originalSpan.get(0).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("JJ"))) {
                remove.add(m);
            }
            if (m.headString.equals("%")) {
                remove.add(m);
            }
            if (headNE.equals("PERCENT") || headNE.equals("MONEY")) {
                remove.add(m);
            }
            if (dict.isAdjectivalDemonym(m.spanToString())) {
                remove.add(m);
            }
            if (!RuleBasedCorefMentionFinder.inStopList(m)) continue;
            remove.add(m);
        }
        for (Mention m1 : mentions) {
            for (Mention m2 : mentions) {
                if (m1 == m2 || remove.contains(m1) || remove.contains(m2) || m1.sentNum != m2.sentNum || m1.headWord != m2.headWord || !m2.insideIn(m1) || m2.endIndex < sent.size() && (((String)((CoreLabel)sent.get(m2.endIndex)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals(",") || ((String)((CoreLabel)sent.get(m2.endIndex)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("CC"))) continue;
                remove.add(m2);
            }
        }
        mentions.removeAll(remove);
    }

    private static boolean inStopList(Mention m) {
        String mentionSpan = m.spanToString().toLowerCase(Locale.ENGLISH);
        if (mentionSpan.equals("u.s.") || mentionSpan.equals("u.k.") || mentionSpan.equals("u.s.s.r")) {
            return true;
        }
        if (mentionSpan.equals("there") || mentionSpan.startsWith("etc.") || mentionSpan.equals("ltd.")) {
            return true;
        }
        if (mentionSpan.startsWith("'s ")) {
            return true;
        }
        return mentionSpan.endsWith("etc.");
    }

    private static boolean partitiveRule(Mention m, List<CoreLabel> sent, Dictionaries dict) {
        return m.startIndex >= 2 && ((String)sent.get(m.startIndex - 1).get(CoreAnnotations.TextAnnotation.class)).equalsIgnoreCase("of") && dict.parts.contains(((String)sent.get(m.startIndex - 2).get(CoreAnnotations.TextAnnotation.class)).toLowerCase(Locale.ENGLISH));
    }

    private static boolean isPleonastic(Mention m, Tree tree) {
        if (!m.spanToString().equalsIgnoreCase("it")) {
            return false;
        }
        for (TregexPattern p : pleonasticPatterns) {
            if (!RuleBasedCorefMentionFinder.checkPleonastic(m, tree, p)) continue;
            return true;
        }
        return false;
    }

    private static TregexPattern[] getPleonasticPatterns() {
        String[] patterns = new String[]{"@NP < (PRP=m1 < it|IT|It) $.. (@VP < (/^V.*/ < /^(?i:is|was|be|becomes|become|became)$/ $.. (@VP < (VBN $.. @S|SBAR))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (ADJP $.. (/S|SBAR/))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (ADJP < (/S|SBAR/))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (NP < /S|SBAR/)))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (NP $.. ADVP $.. /S|SBAR/)))", "NP < (PRP=m1) $.. (VP < (MD $.. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (VP < (VBN $.. /S|SBAR/))))))", "NP < (PRP=m1) $.. (VP < (MD $.. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (ADJP $.. (/S|SBAR/))))))", "NP < (PRP=m1) $.. (VP < (MD $.. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (ADJP < (/S|SBAR/))))))", "NP < (PRP=m1) $.. (VP < (MD $.. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (NP < /S|SBAR/)))))", "NP < (PRP=m1) $.. (VP < (MD $.. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (NP $.. ADVP $.. /S|SBAR/)))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:seems|appears|means|follows)/) $.. /S|SBAR/))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:turns|turned)/) $.. PRT $.. /S|SBAR/))"};
        TregexPattern[] tgrepPatterns = new TregexPattern[patterns.length];
        for (int i = 0; i < tgrepPatterns.length; ++i) {
            tgrepPatterns[i] = TregexPattern.compile(patterns[i]);
        }
        return tgrepPatterns;
    }

    private static boolean checkPleonastic(Mention m, Tree tree, TregexPattern tgrepPattern) {
        try {
            TregexMatcher matcher = tgrepPattern.matcher(tree);
            while (matcher.find()) {
                Tree np1 = matcher.getNode("m1");
                if ((Integer)((CoreLabel)np1.label()).get(CoreAnnotations.BeginIndexAnnotation.class) + 1 != (Integer)m.headWord.get(CoreAnnotations.IndexAnnotation.class)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

