/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.tagger.io.TaggedFileRecord;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import edu.stanford.nlp.util.ConfusionMatrix;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.io.IOException;
import java.util.List;

public class TestClassifier {
    private final TaggedFileRecord fileRecord;
    private int numRight;
    private int numWrong;
    private int unknownWords;
    private int numWrongUnknown;
    private int numCorrectSentences;
    private int numSentences;
    private ConfusionMatrix<String> confusionMatrix;
    private boolean writeUnknDict;
    private boolean writeWords;
    private boolean writeTopWords;
    private boolean writeConfusionMatrix;
    MaxentTagger maxentTagger;
    TaggerConfig config;
    String saveRoot;

    public TestClassifier(MaxentTagger maxentTagger) throws IOException {
        this(maxentTagger, maxentTagger.config.getFile());
    }

    public TestClassifier(MaxentTagger maxentTagger, String testFile) throws IOException {
        this.maxentTagger = maxentTagger;
        this.config = maxentTagger.config;
        this.setDebug(this.config.getDebug());
        this.fileRecord = TaggedFileRecord.createRecord(this.config, testFile);
        this.saveRoot = this.config.getDebugPrefix();
        if (this.saveRoot == null || this.saveRoot.equals("")) {
            this.saveRoot = this.fileRecord.filename();
        }
        this.test();
        if (this.writeConfusionMatrix) {
            PrintFile pf = new PrintFile(this.saveRoot + ".confusion");
            pf.print(this.confusionMatrix.toString());
            pf.close();
        }
    }

    private void processResults(TestSentence testS, PrintFile wordsFile, PrintFile unknDictFile, PrintFile topWordsFile, boolean verboseResults) {
        ++this.numSentences;
        testS.writeTagsAndErrors(testS.finalTags, unknDictFile, verboseResults);
        if (this.writeUnknDict) {
            testS.printUnknown(this.numSentences, unknDictFile);
        }
        if (this.writeTopWords) {
            testS.printTop(topWordsFile);
        }
        testS.updateConfusionMatrix(testS.finalTags, this.confusionMatrix);
        this.numWrong += testS.numWrong;
        this.numRight += testS.numRight;
        this.unknownWords += testS.numUnknown;
        this.numWrongUnknown += testS.numWrongUnknown;
        if (testS.numWrong == 0) {
            ++this.numCorrectSentences;
        }
        if (verboseResults) {
            System.err.println("Sentence number: " + this.numSentences + "; length " + (testS.size - 1) + "; correct: " + testS.numRight + "; wrong: " + testS.numWrong + "; unknown wrong: " + testS.numWrongUnknown);
            System.err.println("  Total tags correct: " + this.numRight + "; wrong: " + this.numWrong + "; unknown wrong: " + this.numWrongUnknown);
        }
    }

    private void test() throws IOException {
        this.numSentences = 0;
        this.confusionMatrix = new ConfusionMatrix();
        PrintFile pf = null;
        PrintFile pf1 = null;
        PrintFile pf3 = null;
        if (this.writeWords) {
            pf = new PrintFile(this.saveRoot + ".words");
        }
        if (this.writeUnknDict) {
            pf1 = new PrintFile(this.saveRoot + ".un.dict");
        }
        if (this.writeTopWords) {
            pf3 = new PrintFile(this.saveRoot + ".words.top");
        }
        boolean verboseResults = this.config.getVerboseResults();
        if (this.config.getNThreads() != 1) {
            MulticoreWrapper<List<TaggedWord>, TestSentence> wrapper = new MulticoreWrapper<List<TaggedWord>, TestSentence>(this.config.getNThreads(), new TestSentenceProcessor(this.maxentTagger));
            for (List taggedSentence : this.fileRecord.reader()) {
                wrapper.put(taggedSentence);
                while (wrapper.peek()) {
                    this.processResults(wrapper.poll(), pf, pf1, pf3, verboseResults);
                }
            }
            wrapper.join();
            while (wrapper.peek()) {
                this.processResults(wrapper.poll(), pf, pf1, pf3, verboseResults);
            }
        } else {
            for (List taggedSentence : this.fileRecord.reader()) {
                TestSentence testS = new TestSentence(this.maxentTagger);
                testS.setCorrectTags(taggedSentence);
                testS.tagSentence(taggedSentence, false);
                this.processResults(testS, pf, pf1, pf3, verboseResults);
            }
        }
        if (pf != null) {
            pf.close();
        }
        if (pf1 != null) {
            pf1.close();
        }
        if (pf3 != null) {
            pf3.close();
        }
    }

    String resultsString(MaxentTagger maxentTagger) {
        StringBuilder output = new StringBuilder();
        output.append(String.format("Model %s has xSize=%d, ySize=%d, and numFeatures=%d.%n", maxentTagger.config.getModel(), maxentTagger.xSize, maxentTagger.ySize, maxentTagger.getLambdaSolve().lambda.length));
        output.append(String.format("Results on %d sentences and %d words, of which %d were unknown.%n", this.numSentences, this.numRight + this.numWrong, this.unknownWords));
        output.append(String.format("Total sentences right: %d (%f%%); wrong: %d (%f%%).%n", this.numCorrectSentences, (double)this.numCorrectSentences * 100.0 / (double)this.numSentences, this.numSentences - this.numCorrectSentences, (double)(this.numSentences - this.numCorrectSentences) * 100.0 / (double)this.numSentences));
        output.append(String.format("Total tags right: %d (%f%%); wrong: %d (%f%%).%n", this.numRight, (double)this.numRight * 100.0 / (double)(this.numRight + this.numWrong), this.numWrong, (double)this.numWrong * 100.0 / (double)(this.numRight + this.numWrong)));
        if (this.unknownWords > 0) {
            output.append(String.format("Unknown words right: %d (%f%%); wrong: %d (%f%%).%n", this.unknownWords - this.numWrongUnknown, 100.0 - (double)this.numWrongUnknown * 100.0 / (double)this.unknownWords, this.numWrongUnknown, (double)this.numWrongUnknown * 100.0 / (double)this.unknownWords));
        }
        return output.toString();
    }

    void printModelAndAccuracy(MaxentTagger maxentTagger) {
        System.err.println(this.resultsString(maxentTagger));
    }

    int getNumWords() {
        return this.numRight + this.numWrong;
    }

    void setDebug(boolean status) {
        this.writeUnknDict = status;
        this.writeWords = status;
        this.writeTopWords = status;
        this.writeConfusionMatrix = status;
    }

    static class TestSentenceProcessor
    implements ThreadsafeProcessor<List<TaggedWord>, TestSentence> {
        MaxentTagger maxentTagger;

        public TestSentenceProcessor(MaxentTagger maxentTagger) {
            this.maxentTagger = maxentTagger;
        }

        @Override
        public TestSentence process(List<TaggedWord> taggedSentence) {
            TestSentence testS = new TestSentence(this.maxentTagger);
            testS.setCorrectTags(taggedSentence);
            testS.tagSentence(taggedSentence, false);
            return testS;
        }

        @Override
        public ThreadsafeProcessor<List<TaggedWord>, TestSentence> newInstance() {
            return this;
        }
    }
}

