/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.util.Generics;
import java.util.Map;

class VariableStrings {
    private Map<Object, String> varsToStrings = Generics.newHashMap();
    private IntCounter<Object> numVarsSet = new IntCounter();

    public boolean isSet(Object o) {
        return this.numVarsSet.getCount(o) == 1.0;
    }

    public void setVar(Object var, String string) {
        String oldString = this.varsToStrings.put(var, string);
        if (oldString != null && !oldString.equals(string)) {
            throw new RuntimeException("Error -- can't setVar to a different string -- old: " + oldString + " new: " + string);
        }
        this.numVarsSet.incrementCount(var);
    }

    public void unsetVar(Object var) {
        if (this.numVarsSet.getCount(var) > 0.0) {
            this.numVarsSet.decrementCount(var);
        }
        if (this.numVarsSet.getCount(var) == 0.0) {
            this.varsToStrings.put(var, null);
        }
    }

    public String getString(Object var) {
        return this.varsToStrings.get(var);
    }
}

