/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.util.CoreMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MorphaAnnotator
implements Annotator {
    private boolean VERBOSE = false;
    private static final String[] prep = new String[]{"abroad", "across", "after", "ahead", "along", "aside", "away", "around", "back", "down", "forward", "in", "off", "on", "over", "out", "round", "together", "through", "up"};
    private static final List<String> particles = Arrays.asList(prep);

    public MorphaAnnotator() {
        this(true);
    }

    public MorphaAnnotator(boolean verbose) {
        this.VERBOSE = verbose;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.VERBOSE) {
            System.err.print("Finding lemmas ...");
        }
        Morphology morphology = new Morphology();
        if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (CoreLabel token : tokens) {
                    String text = (String)token.get(CoreAnnotations.TextAnnotation.class);
                    String posTag = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    MorphaAnnotator.addLemma(morphology, CoreAnnotations.LemmaAnnotation.class, token, text, posTag);
                }
            }
        } else {
            throw new RuntimeException("Unable to find words/tokens in: " + annotation);
        }
    }

    private static void addLemma(Morphology morpha, Class<? extends CoreAnnotation<String>> ann, CoreMap map, String word, String tag) {
        if (tag.length() > 0) {
            String phrasalVerb = MorphaAnnotator.phrasalVerb(morpha, word, tag);
            if (phrasalVerb == null) {
                map.set(ann, morpha.lemma(word, tag));
            } else {
                map.set(ann, phrasalVerb);
            }
        } else {
            map.set(ann, morpha.stem(word));
        }
    }

    private static String phrasalVerb(Morphology morpha, String word, String tag) {
        assert (word != null);
        assert (tag != null);
        if (!tag.startsWith("VB") || !word.contains("_")) {
            return null;
        }
        String[] verb = word.split("_");
        if (verb.length != 2) {
            return null;
        }
        String particle = verb[1];
        if (particles.contains(particle)) {
            String base = verb[0];
            String lemma = morpha.lemma(base, tag);
            return lemma + '_' + particle;
        }
        return null;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return TOKENIZE_SSPLIT_POS;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(LEMMA_REQUIREMENT);
    }
}

