/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.parser.lexparser.TreeBinarizer;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ReflectionLoading;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class BinarizerAnnotator
implements Annotator {
    private static final String DEFAULT_TLPP_CLASS = "edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams";
    final TreeBinarizer binarizer;
    final String tlppClass;

    public BinarizerAnnotator(String annotatorName, Properties props) {
        this.tlppClass = props.getProperty(annotatorName + ".tlppClass", DEFAULT_TLPP_CLASS);
        TreebankLangParserParams tlpp = (TreebankLangParserParams)ReflectionLoading.loadByReflection(this.tlppClass, new Object[0]);
        this.binarizer = new TreeBinarizer(tlpp.headFinder(), tlpp.treebankLanguagePack(), false, false, 0, false, false, 0.0, false, true, true);
    }

    public static String signature(String annotatorName, Properties props) {
        String tlppClass = props.getProperty(annotatorName + ".tlppClass", DEFAULT_TLPP_CLASS);
        return tlppClass;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                this.doOneSentence(sentence);
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    private void doOneSentence(CoreMap sentence) {
        Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
        Tree binarized = this.isBinarized(tree) ? tree : this.binarizer.transformTree(tree);
        Trees.convertToCoreLabels(binarized);
        sentence.set(TreeCoreAnnotations.BinarizedTreeAnnotation.class, binarized);
    }

    private boolean isBinarized(Tree tree) {
        if (tree.isLeaf()) {
            return true;
        }
        if (tree.children().length > 2) {
            return false;
        }
        for (Tree child : tree.children()) {
            if (this.isBinarized(child)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return Collections.singleton(PARSE_REQUIREMENT);
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(BINARIZED_TREES_REQUIREMENT);
    }
}

