/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.patterns.surface.ApplyPatternsMulti;
import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.Data;
import edu.stanford.nlp.patterns.surface.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.surface.PhraseScorer;
import edu.stanford.nlp.patterns.surface.ScorePhrasesAverageFeatures;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.stats.TwoDimensionalCounterInterface;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class ScorePhrases {
    Map<String, Boolean> writtenInJustification = new HashMap<String, Boolean>();
    ConstantsAndVariables constVars = null;
    @Execution.Option(name="phraseScorerClass")
    Class<? extends PhraseScorer> phraseScorerClass = ScorePhrasesAverageFeatures.class;
    PhraseScorer phraseScorer = null;

    public ScorePhrases(Properties props, ConstantsAndVariables cv) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Execution.fillOptions((Object)this, props);
        this.constVars = cv;
        this.phraseScorer = this.phraseScorerClass.getConstructor(ConstantsAndVariables.class).newInstance(this.constVars);
        Execution.fillOptions((Object)this.phraseScorer, props);
    }

    public Counter<String> chooseTopWords(Counter<String> newdt, TwoDimensionalCounter<String, SurfacePattern> terms, Counter<String> useThresholdNumPatternsForTheseWords, Set<String> ignoreWords, double thresholdWordExtract) {
        String w;
        Iterator termIter = Counters.toPriorityQueue(newdt).iterator();
        ClassicCounter<String> finalwords = new ClassicCounter<String>();
        while (termIter.hasNext() && finalwords.size() < this.constVars.numWordsToAdd && !(newdt.getCount(w = (String)termIter.next()) < thresholdWordExtract)) {
            assert (newdt.getCount(w) != Double.POSITIVE_INFINITY);
            if (useThresholdNumPatternsForTheseWords.containsKey(w) && this.numNonRedundantPatterns(terms, w) < this.constVars.thresholdNumPatternsApplied) {
                Redwood.log("extremePatDebug", "Not adding " + w + " because the number of non redundant patterns are below threshold: " + ((ClassicCounter)terms.getCounter((Object)w)).keySet());
                continue;
            }
            String matchedFuzzy = null;
            if (this.constVars.minLen4FuzzyForPattern > 0 && ignoreWords != null) {
                matchedFuzzy = ConstantsAndVariables.containsFuzzy(ignoreWords, w, this.constVars.minLen4FuzzyForPattern);
            }
            if (matchedFuzzy == null) {
                Redwood.log("extremePatDebug", "adding word " + w);
                finalwords.setCount(w, newdt.getCount(w));
                continue;
            }
            Redwood.log("extremePatDebug", "not adding " + w + " because it matched " + matchedFuzzy + " in common English word");
            ignoreWords.add(w);
        }
        String nextFive = "";
        int n = 0;
        while (termIter.hasNext() && ++n <= 5) {
            String w2 = (String)termIter.next();
            nextFive = nextFive + ";\t" + w2 + ":" + newdt.getCount(w2);
        }
        Redwood.log(new Object[]{Redwood.DBG, "Next five phrases were " + nextFive});
        return finalwords;
    }

    public static <E, F> void removeKeys(TwoDimensionalCounter<E, F> counter, Collection<E> removeKeysCollection) {
        for (E key : removeKeysCollection) {
            counter.remove(key);
        }
    }

    private double numNonRedundantPatterns(TwoDimensionalCounter<String, SurfacePattern> terms, String w) {
        SurfacePattern[] pats = ((ClassicCounter)terms.getCounter((Object)w)).keySet().toArray(new SurfacePattern[0]);
        int numPat = 0;
        for (int i = 0; i < pats.length; ++i) {
            String pati = pats[i].toString();
            boolean contains = false;
            for (int j = i + 1; j < pats.length; ++j) {
                String patj = pats[j].toString();
                if (!patj.contains(pati) && !pati.contains(patj)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            ++numPat;
        }
        return numPat;
    }

    public Counter<String> learnNewPhrases(String label, Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>> patternsForEachToken, Counter<SurfacePattern> patternsLearnedThisIter, Counter<SurfacePattern> allSelectedPatterns, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>> tokensMatchedPatterns, Counter<String> scoreForAllWordsThisIteration, TwoDimensionalCounter<String, SurfacePattern> terms, TwoDimensionalCounter<String, SurfacePattern> wordsPatExtracted, Counter<SurfacePattern> currentAllPatternWeights, TwoDimensionalCounter<SurfacePattern, String> patternsAndWords4Label, TwoDimensionalCounter<SurfacePattern, String> allPatternsAndWords4Label, String identifier, Set<String> ignoreWords) throws InterruptedException, ExecutionException, IOException, ClassNotFoundException {
        boolean computeDataFreq = false;
        if (Data.processedDataFreq == null || Data.rawFreq == null) {
            Data.rawFreq = new ClassicCounter<String>();
            computeDataFreq = true;
            Data.processedDataFreq = new ClassicCounter<String>();
        }
        Counter<String> words = this.learnNewPhrasesPrivate(label, patternsForEachToken, patternsLearnedThisIter, allSelectedPatterns, this.constVars.getLabelDictionary().get(label), tokensMatchedPatterns, scoreForAllWordsThisIteration, terms, wordsPatExtracted, currentAllPatternWeights, patternsAndWords4Label, allPatternsAndWords4Label, identifier, ignoreWords, computeDataFreq);
        this.constVars.addLabelDictionary(label, words.keySet());
        return words;
    }

    void runParallelApplyPats(Map<String, List<CoreLabel>> sents, Set<String> sentIds, String label, Counter<SurfacePattern> patternsLearnedThisIter, TwoDimensionalCounter<Pair<String, String>, SurfacePattern> wordsandLemmaPatExtracted, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>> matchedTokensByPat) throws InterruptedException, ExecutionException {
        ArrayList<String> keyset = new ArrayList<String>(sentIds);
        ArrayList<String> notAllowedClasses = new ArrayList<String>();
        if (this.constVars.doNotExtractPhraseAnyWordLabeledOtherClass) {
            for (String l : this.constVars.answerClass.keySet()) {
                if (l.equals(label)) continue;
                notAllowedClasses.add(l + ":" + l);
            }
            notAllowedClasses.add("OTHERSEM:OTHERSEM");
        }
        int num = 0;
        num = this.constVars.numThreads == 1 ? keyset.size() : keyset.size() / (this.constVars.numThreads - 1);
        ExecutorService executor = Executors.newFixedThreadPool(this.constVars.numThreads);
        ArrayList<Future<Pair<TwoDimensionalCounter<Pair<String, String>, SurfacePattern>, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>>>>> list = new ArrayList<Future<Pair<TwoDimensionalCounter<Pair<String, String>, SurfacePattern>, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>>>>>();
        for (int i = 0; i < this.constVars.numThreads; ++i) {
            Object var13_16 = null;
            HashMap<TokenSequencePattern, SurfacePattern> patternsLearnedThisIterConverted = new HashMap<TokenSequencePattern, SurfacePattern>();
            for (SurfacePattern p : patternsLearnedThisIter.keySet()) {
                TokenSequencePattern pat = TokenSequencePattern.compile(this.constVars.env.get(label), p.toString(notAllowedClasses));
                patternsLearnedThisIterConverted.put(pat, p);
            }
            ApplyPatternsMulti applyPatternsMulti = new ApplyPatternsMulti(sents, keyset.subList(i * num, Math.min(keyset.size(), (i + 1) * num)), patternsLearnedThisIterConverted, label, this.constVars.removeStopWordsFromSelectedPhrases, this.constVars.removePhrasesWithStopWords, this.constVars);
            Future<Pair<TwoDimensionalCounter<Pair<String, String>, SurfacePattern>, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>>>> submit = executor.submit(applyPatternsMulti);
            list.add(submit);
        }
        for (Future future : list) {
            try {
                Pair result = (Pair)future.get();
                wordsandLemmaPatExtracted.addAll((TwoDimensionalCounterInterface)result.first());
                matchedTokensByPat.addAll((CollectionValuedMap)result.second());
            }
            catch (Exception e) {
                executor.shutdownNow();
                throw new RuntimeException(e);
            }
        }
        executor.shutdown();
    }

    public void applyPats(Counter<SurfacePattern> patterns, String label, boolean computeDataFreq, TwoDimensionalCounter<Pair<String, String>, SurfacePattern> wordsandLemmaPatExtracted, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>> matchedTokensByPat) throws ClassNotFoundException, IOException, InterruptedException, ExecutionException {
        ClassicCounter<SurfacePattern> patternsLearnedThisIterConsistsOnlyGeneralized = new ClassicCounter<SurfacePattern>();
        ClassicCounter<SurfacePattern> patternsLearnedThisIterRest = new ClassicCounter<SurfacePattern>();
        Set<String> specialWords = this.constVars.invertedIndex.getSpecialWordsList();
        List<String> extremelySmallStopWordsList = Arrays.asList(".", ",", "in", "on", "of", "a", "the", "an");
        for (Map.Entry<SurfacePattern, Double> en : patterns.entrySet()) {
            SurfacePattern p = en.getKey();
            String[] stringArray = p.getSimplerTokensNext();
            String[] pr = p.getSimplerTokensPrev();
            boolean rest = false;
            if (stringArray != null) {
                for (String e : stringArray) {
                    if (specialWords.contains(e)) continue;
                    rest = true;
                    break;
                }
            }
            if (!rest && pr != null) {
                for (String e : pr) {
                    if (specialWords.contains(e) || extremelySmallStopWordsList.contains(e)) continue;
                    rest = true;
                    break;
                }
            }
            if (rest) {
                patternsLearnedThisIterRest.setCount(en.getKey(), en.getValue());
                continue;
            }
            patternsLearnedThisIterConsistsOnlyGeneralized.setCount(en.getKey(), en.getValue());
        }
        Map<String, Set<String>> sentidswithfilerest = this.constVars.invertedIndex.getFileSentIdsFromPats(patternsLearnedThisIterRest.keySet());
        if (this.constVars.batchProcessSents) {
            List<File> filesToLoad;
            if (patternsLearnedThisIterConsistsOnlyGeneralized.size() > 0) {
                filesToLoad = Data.sentsFiles;
            } else {
                filesToLoad = new ArrayList<File>();
                for (String string : sentidswithfilerest.keySet()) {
                    String filename = "";
                    filename = this.constVars.usingDirForSentsInIndex ? this.constVars.saveSentencesSerDir + "/" + string : string;
                    filesToLoad.add(new File(filename));
                }
            }
            for (File file : filesToLoad) {
                Redwood.log(new Object[]{Redwood.DBG, "Applying patterns to sents from " + file});
                Map sents = (Map)IOUtils.readObjectFromFile(file);
                if (sentidswithfilerest != null && !sentidswithfilerest.isEmpty()) {
                    String filename = "";
                    filename = this.constVars.usingDirForSentsInIndex ? this.constVars.saveSentencesSerDir + "/" + file.getName() : file.getAbsolutePath();
                    Set<String> sentIDs = sentidswithfilerest.get(filename);
                    if (sentIDs != null) {
                        this.runParallelApplyPats(sents, sentIDs, label, patternsLearnedThisIterRest, wordsandLemmaPatExtracted, matchedTokensByPat);
                    } else {
                        throw new RuntimeException("How come no sentIds for " + filename + ". Index keyset is " + this.constVars.invertedIndex.getKeySet());
                    }
                }
                if (patternsLearnedThisIterConsistsOnlyGeneralized.size() > 0) {
                    this.runParallelApplyPats(sents, sents.keySet(), label, patternsLearnedThisIterConsistsOnlyGeneralized, wordsandLemmaPatExtracted, matchedTokensByPat);
                }
                if (!computeDataFreq) continue;
                Data.computeRawFreqIfNull(sents, this.constVars.numWordsCompound);
            }
        } else {
            if (sentidswithfilerest != null && !sentidswithfilerest.isEmpty()) {
                String filename = CollectionUtils.toList(sentidswithfilerest.keySet()).get(0);
                Set<String> sentids = sentidswithfilerest.get(filename);
                if (sentids != null) {
                    this.runParallelApplyPats(Data.sents, sentids, label, patternsLearnedThisIterRest, wordsandLemmaPatExtracted, matchedTokensByPat);
                } else {
                    throw new RuntimeException("How come no sentIds for " + filename + ". Index keyset is " + this.constVars.invertedIndex.getKeySet());
                }
            }
            if (patternsLearnedThisIterConsistsOnlyGeneralized.size() > 0) {
                this.runParallelApplyPats(Data.sents, Data.sents.keySet(), label, patternsLearnedThisIterConsistsOnlyGeneralized, wordsandLemmaPatExtracted, matchedTokensByPat);
            }
            Data.computeRawFreqIfNull(Data.sents, this.constVars.numWordsCompound);
        }
        Redwood.log(new Object[]{Redwood.DBG, "# words/lemma and pattern pairs are " + wordsandLemmaPatExtracted.size()});
    }

    private void statsWithoutApplyingPatterns(Map<String, List<CoreLabel>> sents, Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>> patternsForEachToken, Counter<SurfacePattern> patternsLearnedThisIter, TwoDimensionalCounter<Pair<String, String>, SurfacePattern> wordsandLemmaPatExtracted) {
        for (Map.Entry<String, List<CoreLabel>> sentEn : sents.entrySet()) {
            Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>> pat4Sent = patternsForEachToken.get(sentEn.getKey());
            if (pat4Sent == null) {
                throw new RuntimeException("How come there are no patterns for " + sentEn.getKey() + ". The total patternsForEachToken size is " + patternsForEachToken.size() + " and keys " + patternsForEachToken.keySet());
            }
            for (Map.Entry<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>> en : pat4Sent.entrySet()) {
                CoreLabel token = null;
                Set<SurfacePattern> p1 = en.getValue().first();
                Set<SurfacePattern> p2 = en.getValue().second();
                Set<SurfacePattern> p3 = en.getValue().third();
                for (SurfacePattern p : patternsLearnedThisIter.keySet()) {
                    if (!p1.contains(p) && !p2.contains(p) && !p3.contains(p)) continue;
                    if (token == null) {
                        token = sentEn.getValue().get(en.getKey());
                    }
                    wordsandLemmaPatExtracted.incrementCount(new Pair<String, String>(token.word(), token.lemma()), p);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Counter<String> learnNewPhrasesPrivate(String label, Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>> patternsForEachToken, Counter<SurfacePattern> patternsLearnedThisIter, Counter<SurfacePattern> allSelectedPatterns, Set<String> alreadyIdentifiedWords, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>> matchedTokensByPat, Counter<String> scoreForAllWordsThisIteration, TwoDimensionalCounter<String, SurfacePattern> terms, TwoDimensionalCounter<String, SurfacePattern> wordsPatExtracted, Counter<SurfacePattern> currentAllPatternWeights, TwoDimensionalCounter<SurfacePattern, String> patternsAndWords4Label, TwoDimensionalCounter<SurfacePattern, String> allPatternsAndWords4Label, String identifier, Set<String> ignoreWords, boolean computeDataFreq) throws InterruptedException, ExecutionException, IOException, ClassNotFoundException {
        TwoDimensionalCounter<Pair<String, String>, SurfacePattern> wordsandLemmaPatExtracted = new TwoDimensionalCounter<Pair<String, String>, SurfacePattern>();
        if (this.constVars.doNotApplyPatterns) {
            if (this.constVars.batchProcessSents) {
                for (File file : Data.sentsFiles) {
                    Redwood.log(new Object[]{Redwood.DBG, "Calculating stats from sents file " + file});
                    Map sents = (Map)IOUtils.readObjectFromFile(file);
                    this.statsWithoutApplyingPatterns(sents, patternsForEachToken, patternsLearnedThisIter, wordsandLemmaPatExtracted);
                }
            } else {
                this.statsWithoutApplyingPatterns(Data.sents, patternsForEachToken, patternsLearnedThisIter, wordsandLemmaPatExtracted);
            }
        } else if (patternsLearnedThisIter.size() > 0) {
            this.applyPats(patternsLearnedThisIter, label, computeDataFreq, wordsandLemmaPatExtracted, matchedTokensByPat);
        }
        if (computeDataFreq) {
            if (!this.phraseScorer.wordFreqNorm.equals((Object)PhraseScorer.Normalization.NONE)) {
                Redwood.log(new Object[]{Redwood.DBG, "computing processed freq"});
                for (Map.Entry entry : Data.rawFreq.entrySet()) {
                    double in = (Double)entry.getValue();
                    if (this.phraseScorer.wordFreqNorm.equals((Object)PhraseScorer.Normalization.SQRT)) {
                        in = Math.sqrt(in);
                    } else if (this.phraseScorer.wordFreqNorm.equals((Object)PhraseScorer.Normalization.LOG)) {
                        in = 1.0 + Math.log(in);
                    } else {
                        throw new RuntimeException("can't understand the normalization");
                    }
                    Data.processedDataFreq.setCount((String)entry.getKey(), in);
                }
            } else {
                Data.processedDataFreq = Data.rawFreq;
            }
        }
        if (this.constVars.wordScoring.equals((Object)GetPatternsFromDataMultiClass.WordScoring.WEIGHTEDNORM)) {
            void var18_25;
            for (Pair pair : wordsandLemmaPatExtracted.firstKeySet()) {
                if (!this.constVars.getOtherSemanticClasses().contains(pair.first()) && !this.constVars.getOtherSemanticClasses().contains(pair.second())) {
                    terms.addAll((String)pair.first(), wordsandLemmaPatExtracted.getCounter((Object)pair));
                }
                wordsPatExtracted.addAll((String)pair.first(), wordsandLemmaPatExtracted.getCounter((Object)pair));
            }
            ScorePhrases.removeKeys(terms, this.constVars.getStopWords());
            Counter<String> phraseScores = this.phraseScorer.scorePhrases(label, terms, wordsPatExtracted, allSelectedPatterns, alreadyIdentifiedWords, false);
            if (ignoreWords != null && !ignoreWords.isEmpty()) {
                Set<String> set = CollectionUtils.unionAsSet(ignoreWords, this.constVars.getOtherSemanticClasses());
            } else {
                Set<String> set = this.constVars.getOtherSemanticClasses();
            }
            Counter<String> finalwords = this.chooseTopWords(phraseScores, terms, phraseScores, (Set<String>)var18_25, this.constVars.thresholdWordExtract);
            scoreForAllWordsThisIteration.clear();
            Counters.addInPlace(scoreForAllWordsThisIteration, phraseScores);
            Redwood.log(ConstantsAndVariables.minimaldebug, "## Selected Words: " + Counters.toSortedString(finalwords, finalwords.size(), "%1$s:%2$.2f", "\t"));
            if (this.constVars.outDir != null && !this.constVars.outDir.isEmpty()) {
                String outputdir = this.constVars.outDir + "/" + identifier + "/" + label;
                IOUtils.ensureDir(new File(outputdir));
                TwoDimensionalCounter<String, String> reasonForWords = new TwoDimensionalCounter<String, String>();
                for (String word : finalwords.keySet()) {
                    for (SurfacePattern l : ((ClassicCounter)wordsPatExtracted.getCounter((Object)word)).keySet()) {
                        Iterator i$ = ((ClassicCounter)patternsAndWords4Label.getCounter((Object)l)).iterator();
                        while (i$.hasNext()) {
                            String w2 = (String)i$.next();
                            reasonForWords.incrementCount(word, w2);
                        }
                    }
                }
                Redwood.log(ConstantsAndVariables.minimaldebug, "Saving output in " + outputdir);
                String filename = outputdir + "/words.json";
                JsonArrayBuilder obj = Json.createArrayBuilder();
                if (this.writtenInJustification.containsKey(label) && this.writtenInJustification.get(label).booleanValue()) {
                    JsonReader jsonReader = Json.createReader((InputStream)new BufferedInputStream(new FileInputStream(filename)));
                    JsonArray objarr = jsonReader.readArray();
                    for (JsonValue o : objarr) {
                        obj.add(o);
                    }
                    jsonReader.close();
                }
                JsonArrayBuilder objThisIter = Json.createArrayBuilder();
                for (String w : reasonForWords.firstKeySet()) {
                    JsonObjectBuilder objinner = Json.createObjectBuilder();
                    JsonArrayBuilder l = Json.createArrayBuilder();
                    for (String w2 : ((ClassicCounter)reasonForWords.getCounter((Object)w)).keySet()) {
                        l.add(w2);
                    }
                    JsonArrayBuilder pats = Json.createArrayBuilder();
                    Iterator i$ = ((ClassicCounter)wordsPatExtracted.getCounter((Object)w)).iterator();
                    while (i$.hasNext()) {
                        SurfacePattern p = (SurfacePattern)i$.next();
                        pats.add(p.toStringSimple());
                    }
                    objinner.add("reasonwords", l);
                    objinner.add("patterns", pats);
                    objinner.add("score", finalwords.getCount(w));
                    objinner.add("entity", w);
                    objThisIter.add((JsonValue)objinner.build());
                }
                obj.add(objThisIter);
                IOUtils.writeStringToFile(obj.build().toString(), filename, "utf8");
                this.writtenInJustification.put(label, true);
            }
            if (this.constVars.justify) {
                Redwood.log(new Object[]{Redwood.DBG, "\nJustification for phrases:\n"});
                for (String word : finalwords.keySet()) {
                    Redwood.log(new Object[]{Redwood.DBG, "Phrase " + word + " extracted because of patterns: \t" + Counters.toSortedString(wordsPatExtracted.getCounter((Object)word), ((ClassicCounter)wordsPatExtracted.getCounter((Object)word)).size(), "%1$s:%2$f", "\n")});
                }
            }
            return finalwords;
        }
        if (this.constVars.wordScoring.equals((Object)GetPatternsFromDataMultiClass.WordScoring.BPB)) {
            Counters.addInPlace(terms, wordsPatExtracted);
            ClassicCounter<String> maxPatWeightTerms = new ClassicCounter<String>();
            HashMap hashMap = new HashMap();
            for (Map.Entry<String, ClassicCounter<SurfacePattern>> en : terms.entrySet()) {
                ClassicCounter<SurfacePattern> weights = new ClassicCounter<SurfacePattern>();
                for (SurfacePattern k : en.getValue().keySet()) {
                    weights.setCount(k, patternsLearnedThisIter.getCount(k));
                }
                maxPatWeightTerms.setCount(en.getKey(), Counters.max(weights));
                hashMap.put(en.getKey(), Counters.argmax(weights));
            }
            Counters.removeKeys(maxPatWeightTerms, alreadyIdentifiedWords);
            double maxvalue = Counters.max(maxPatWeightTerms);
            Set<String> words = Counters.keysAbove(maxPatWeightTerms, maxvalue - 1.0E-10);
            String bestw = null;
            if (words.size() > 1) {
                double max = Double.NEGATIVE_INFINITY;
                for (String w : words) {
                    if (!(terms.getCount(w, (SurfacePattern)hashMap.get(w)) > max)) continue;
                    max = terms.getCount(w, (SurfacePattern)hashMap.get(w));
                    bestw = w;
                }
            } else if (words.size() == 1) {
                bestw = words.iterator().next();
            } else {
                return new ClassicCounter<String>();
            }
            Redwood.log(ConstantsAndVariables.minimaldebug, "Selected Words: " + bestw);
            return Counters.asCounter(Arrays.asList(bestw));
        }
        throw new RuntimeException("wordscoring " + (Object)((Object)this.constVars.wordScoring) + " not identified");
    }

    Counter<String> getLearnedScores() {
        return this.phraseScorer.getLearnedScores();
    }
}

