/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceCharSeq;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceDocument;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEntityMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceRelation;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceRelationMentionArgument;

public class AceRelationMention
extends AceMention {
    private String mLexicalCondition;
    private AceRelationMentionArgument[] mArguments;
    private AceRelation mParent;

    public AceRelationMention(String id, AceCharSeq extent, String lc) {
        super(id, extent);
        this.mLexicalCondition = lc;
        this.mArguments = new AceRelationMentionArgument[2];
    }

    public AceRelationMentionArgument[] getArgs() {
        return this.mArguments;
    }

    public AceEntityMention getArg(int which) {
        return this.mArguments[which].getContent();
    }

    public void setArg(int which, AceEntityMention em, String role) {
        this.mArguments[which] = new AceRelationMentionArgument(role, em);
    }

    public AceEntityMention getFirstArg() {
        if (this.getArg(0).getHead().getTokenStart() <= this.getArg(1).getHead().getTokenStart()) {
            return this.getArg(0);
        }
        return this.getArg(1);
    }

    public AceEntityMention getLastArg() {
        if (this.getArg(0).getHead().getTokenStart() > this.getArg(1).getHead().getTokenStart()) {
            return this.getArg(0);
        }
        return this.getArg(1);
    }

    public void setParent(AceRelation e) {
        this.mParent = e;
    }

    public AceRelation getParent() {
        return this.mParent;
    }

    public String getLexicalCondition() {
        return this.mLexicalCondition;
    }

    public int getSentence(AceDocument doc) {
        return doc.getToken(this.getArg(0).getHead().getTokenStart()).getSentence();
    }

    public int getMinTokenStart() {
        int s1 = this.getArg(0).getHead().getTokenStart();
        int s2 = this.getArg(1).getHead().getTokenStart();
        return Math.min(s1, s2);
    }

    public int getMaxTokenEnd() {
        int s1 = this.getArg(0).getHead().getTokenEnd();
        int s2 = this.getArg(1).getHead().getTokenEnd();
        return Math.max(s1, s2);
    }

    @Override
    public String toXml(int offset) {
        StringBuffer buffer = new StringBuffer();
        AceRelationMention.appendOffset(buffer, offset);
        buffer.append("<relation_mention ID=\"" + this.getId() + "\"");
        if (this.mLexicalCondition != null) {
            buffer.append(" LEXICALCONDITION=\"" + this.mLexicalCondition + "\"");
        }
        buffer.append(">\n");
        buffer.append(this.mExtent.toXml("extent", offset + 2));
        buffer.append("\n");
        AceRelationMentionArgument arg1 = this.getArgs()[0];
        AceRelationMentionArgument arg2 = this.getArgs()[1];
        if (arg1.getRole().equals("Arg-1")) {
            buffer.append(arg1.toXml(offset + 2) + "\n");
            buffer.append(arg2.toXml(offset + 2) + "\n");
        } else {
            buffer.append(arg2.toXml(offset + 2) + "\n");
            buffer.append(arg1.toXml(offset + 2) + "\n");
        }
        AceRelationMention.appendOffset(buffer, offset);
        buffer.append("</relation_mention>");
        return buffer.toString();
    }
}

