/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.CorefScorer;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import java.util.Map;

public class ScorerPairwise
extends CorefScorer {
    public ScorerPairwise() {
        super(CorefScorer.ScoreType.Pairwise);
    }

    @Override
    protected void calculateRecall(Document doc) {
        int rDen = 0;
        int rNum = 0;
        Map<Integer, Mention> predictedMentions = doc.allPredictedMentions;
        for (CorefCluster g : doc.goldCorefClusters.values()) {
            int clusterSize = g.getCorefMentions().size();
            rDen += clusterSize * (clusterSize - 1) / 2;
            for (Mention m1 : g.getCorefMentions()) {
                Mention predictedM1 = predictedMentions.get(m1.mentionID);
                if (predictedM1 == null) continue;
                for (Mention m2 : g.getCorefMentions()) {
                    Mention predictedM2;
                    if (m1.mentionID >= m2.mentionID || (predictedM2 = predictedMentions.get(m2.mentionID)) == null || predictedM1.corefClusterID != predictedM2.corefClusterID) continue;
                    ++rNum;
                }
            }
        }
        this.recallDenSum += (double)rDen;
        this.recallNumSum += (double)rNum;
    }

    @Override
    protected void calculatePrecision(Document doc) {
        int pDen = 0;
        int pNum = 0;
        Map<Integer, Mention> goldMentions = doc.allGoldMentions;
        for (CorefCluster c : doc.corefClusters.values()) {
            int clusterSize = c.getCorefMentions().size();
            pDen += clusterSize * (clusterSize - 1) / 2;
            for (Mention m1 : c.getCorefMentions()) {
                Mention goldM1 = goldMentions.get(m1.mentionID);
                if (goldM1 == null) continue;
                for (Mention m2 : c.getCorefMentions()) {
                    Mention goldM2;
                    if (m1.mentionID >= m2.mentionID || (goldM2 = goldMentions.get(m2.mentionID)) == null || goldM1.goldCorefClusterID != goldM2.goldCorefClusterID) continue;
                    ++pNum;
                }
            }
        }
        this.precisionDenSum += (double)pDen;
        this.precisionNumSum += (double)pNum;
    }
}

