/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.fusesource.lmdbjni.ByteString;
import sun.misc.Unsafe;

public class DirectBuffer {
    public static final int SIZE_OF_BYTE = 1;
    public static final int SIZE_OF_BOOLEAN = 1;
    public static final int SIZE_OF_CHAR = 2;
    public static final int SIZE_OF_SHORT = 2;
    public static final int SIZE_OF_INT = 4;
    public static final int SIZE_OF_FLOAT = 4;
    public static final int SIZE_OF_LONG = 8;
    public static final int SIZE_OF_DOUBLE = 8;
    private static final Unsafe UNSAFE;
    public static final String DISABLE_BOUNDS_CHECKS_PROP_NAME = "directbuffer.disable.bounds.checks";
    public static final boolean SHOULD_BOUNDS_CHECK;
    private static final byte[] NULL_BYTES;
    private static final ByteOrder NATIVE_BYTE_ORDER;
    private static final long ARRAY_BASE_OFFSET;
    private byte[] byteArray;
    private ByteBuffer byteBuffer;
    private long addressOffset;
    private int capacity;

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    public DirectBuffer() {
        this.wrap(ByteBuffer.allocateDirect(511));
    }

    public DirectBuffer(byte[] buffer) {
        this.wrap(buffer);
    }

    public DirectBuffer(ByteBuffer buffer) {
        this.wrap(buffer);
    }

    public DirectBuffer(long address, int capacity) {
        this.wrap(address, capacity);
    }

    public DirectBuffer(DirectBuffer buffer) {
        this.wrap(buffer);
    }

    public void wrap(byte[] buffer) {
        this.addressOffset = ARRAY_BASE_OFFSET;
        this.capacity = buffer.length;
        this.byteArray = buffer;
        this.byteBuffer = null;
    }

    public void wrap(ByteBuffer buffer) {
        this.byteBuffer = buffer;
        if (buffer.hasArray()) {
            this.byteArray = buffer.array();
            this.addressOffset = ARRAY_BASE_OFFSET + (long)buffer.arrayOffset();
        } else {
            this.byteArray = null;
            this.addressOffset = ((sun.nio.ch.DirectBuffer)((Object)buffer)).address();
        }
        this.capacity = buffer.capacity();
    }

    public void wrap(long address, int capacity) {
        this.addressOffset = address;
        this.capacity = capacity;
        this.byteArray = null;
        this.byteBuffer = null;
    }

    public void wrap(DirectBuffer buffer) {
        this.addressOffset = buffer.addressOffset();
        this.capacity = buffer.capacity();
        this.byteArray = buffer.byteArray();
        this.byteBuffer = buffer.byteBuffer();
    }

    public long addressOffset() {
        return this.addressOffset;
    }

    public byte[] byteArray() {
        return this.byteArray;
    }

    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    public void setMemory(int index, int length, byte value) {
        this.boundsCheck(index, length);
        UNSAFE.setMemory(this.byteArray, this.addressOffset + (long)index, length, value);
    }

    public int capacity() {
        return this.capacity;
    }

    public void checkLimit(int limit) {
        if (limit > this.capacity) {
            String msg = String.format("limit=%d is beyond capacity=%d", limit, this.capacity);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public ByteBuffer duplicateByteBuffer() {
        if (null == this.byteBuffer) {
            return ByteBuffer.wrap(this.byteArray);
        }
        ByteBuffer duplicate = this.byteBuffer.duplicate();
        duplicate.clear();
        return duplicate;
    }

    public long getLong(int index, ByteOrder byteOrder) {
        this.boundsCheck(index, 8);
        long bits = UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        return bits;
    }

    public void putLong(int index, long value, ByteOrder byteOrder) {
        this.boundsCheck(index, 8);
        long bits = value;
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
    }

    public long getLong(int index) {
        this.boundsCheck(index, 8);
        return UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
    }

    public void putLong(int index, long value) {
        this.boundsCheck(index, 8);
        UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    public long getLongVolatile(int index) {
        this.boundsCheck(index, 8);
        return UNSAFE.getLongVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    public void putLongVolatile(int index, long value) {
        this.boundsCheck(index, 8);
        UNSAFE.putLongVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    public void putLongOrdered(int index, long value) {
        this.boundsCheck(index, 8);
        UNSAFE.putOrderedLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    public void addLongOrdered(int index, long increment) {
        this.boundsCheck(index, 8);
        long offset = this.addressOffset + (long)index;
        byte[] byteArray = this.byteArray;
        long value = UNSAFE.getLong(byteArray, offset);
        UNSAFE.putOrderedLong(byteArray, offset, value + increment);
    }

    public boolean compareAndSetLong(int index, long expectedValue, long updateValue) {
        this.boundsCheck(index, 8);
        return UNSAFE.compareAndSwapLong(this.byteArray, this.addressOffset + (long)index, expectedValue, updateValue);
    }

    public int getInt(int index, ByteOrder byteOrder) {
        this.boundsCheck(index, 4);
        int bits = UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        return bits;
    }

    public void putInt(int index, int value, ByteOrder byteOrder) {
        this.boundsCheck(index, 4);
        int bits = value;
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
    }

    public int getInt(int index) {
        this.boundsCheck(index, 4);
        return UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
    }

    public void putInt(int index, int value) {
        this.boundsCheck(index, 4);
        UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    public int getIntVolatile(int index) {
        this.boundsCheck(index, 4);
        return UNSAFE.getIntVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    public void putIntVolatile(int index, int value) {
        this.boundsCheck(index, 4);
        UNSAFE.putIntVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    public void putIntOrdered(int index, int value) {
        this.boundsCheck(index, 4);
        UNSAFE.putOrderedInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    public void addIntOrdered(int index, int increment) {
        this.boundsCheck(index, 4);
        long offset = this.addressOffset + (long)index;
        byte[] byteArray = this.byteArray;
        int value = UNSAFE.getInt(byteArray, offset);
        UNSAFE.putOrderedInt(byteArray, offset, value + increment);
    }

    public boolean compareAndSetInt(int index, int expectedValue, int updateValue) {
        this.boundsCheck(index, 4);
        return UNSAFE.compareAndSwapInt(this.byteArray, this.addressOffset + (long)index, expectedValue, updateValue);
    }

    public double getDouble(int index, ByteOrder byteOrder) {
        this.boundsCheck(index, 8);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            long bits = UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
            return Double.longBitsToDouble(Long.reverseBytes(bits));
        }
        return UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    public void putDouble(int index, double value, ByteOrder byteOrder) {
        this.boundsCheck(index, 8);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    public double getDouble(int index) {
        this.boundsCheck(index, 8);
        return UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    public void putDouble(int index, double value) {
        this.boundsCheck(index, 8);
        UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
    }

    public float getFloat(int index, ByteOrder byteOrder) {
        this.boundsCheck(index, 4);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            int bits = UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
            return Float.intBitsToFloat(Integer.reverseBytes(bits));
        }
        return UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    public void putFloat(int index, float value, ByteOrder byteOrder) {
        this.boundsCheck(index, 4);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    public float getFloat(int index) {
        this.boundsCheck(index, 4);
        return UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    public void putFloat(int index, float value) {
        this.boundsCheck(index, 4);
        UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
    }

    public short getShort(int index, ByteOrder byteOrder) {
        this.boundsCheck(index, 2);
        short bits = UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        return bits;
    }

    public void putShort(int index, short value, ByteOrder byteOrder) {
        this.boundsCheck(index, 2);
        short bits = value;
        if (NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, bits);
    }

    public short getShort(int index) {
        this.boundsCheck(index, 2);
        return UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
    }

    public void putShort(int index, short value) {
        this.boundsCheck(index, 2);
        UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, value);
    }

    public short getShortVolatile(int index) {
        this.boundsCheck(index, 2);
        return UNSAFE.getShortVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    public void putShortVolatile(int index, short value) {
        this.boundsCheck(index, 2);
        UNSAFE.putShortVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    public byte getByte(int index) {
        this.boundsCheck(index, 1);
        return UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index);
    }

    public void putByte(int index, byte value) {
        this.boundsCheck(index, 1);
        UNSAFE.putByte(this.byteArray, this.addressOffset + (long)index, value);
    }

    public int getBytes(int index, byte[] dst) {
        return this.getBytes(index, dst, 0, dst.length);
    }

    public int getBytes(int index, byte[] dst, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        count = Math.min(count, dst.length);
        this.boundsCheck(index, count);
        UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst, ARRAY_BASE_OFFSET + (long)offset, count);
        return count;
    }

    public void getBytes(int index, DirectBuffer dstBuffer, int dstIndex, int length) {
        dstBuffer.putBytes(dstIndex, this, index, length);
    }

    public int getBytes(int index, ByteBuffer dstBuffer, int length) {
        long dstBaseOffset;
        byte[] dstByteArray;
        int count = Math.min(dstBuffer.remaining(), this.capacity - index);
        count = Math.min(count, length);
        this.boundsCheck(index, count);
        int dstOffset = dstBuffer.position();
        if (dstBuffer.hasArray()) {
            dstByteArray = dstBuffer.array();
            dstBaseOffset = ARRAY_BASE_OFFSET + (long)dstBuffer.arrayOffset();
        } else {
            dstByteArray = null;
            dstBaseOffset = ((sun.nio.ch.DirectBuffer)((Object)dstBuffer)).address();
        }
        UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dstByteArray, dstBaseOffset + (long)dstOffset, count);
        dstBuffer.position(dstBuffer.position() + count);
        return count;
    }

    public int putBytes(int index, byte[] src) {
        return this.putBytes(index, src, 0, src.length);
    }

    public int putBytes(int index, byte[] src, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        count = Math.min(count, src.length);
        this.boundsCheck(index, count);
        UNSAFE.copyMemory(src, ARRAY_BASE_OFFSET + (long)offset, this.byteArray, this.addressOffset + (long)index, length);
        return length;
    }

    public int putBytes(int index, ByteBuffer srcBuffer, int length) {
        int count = Math.min(srcBuffer.remaining(), length);
        count = Math.min(count, this.capacity - index);
        this.boundsCheck(index, count);
        count = this.putBytes(index, srcBuffer, srcBuffer.position(), count);
        srcBuffer.position(srcBuffer.position() + count);
        return count;
    }

    public int putBytes(int index, ByteBuffer srcBuffer, int srcIndex, int length) {
        long srcBaseOffset;
        byte[] srcByteArray;
        int count = Math.min(length, this.capacity - index);
        count = Math.min(count, srcBuffer.capacity() - srcIndex);
        this.boundsCheck(index, count);
        if (srcBuffer.hasArray()) {
            srcByteArray = srcBuffer.array();
            srcBaseOffset = ARRAY_BASE_OFFSET + (long)srcBuffer.arrayOffset() + (long)srcIndex;
        } else {
            srcByteArray = null;
            srcBaseOffset = ((sun.nio.ch.DirectBuffer)((Object)srcBuffer)).address();
        }
        UNSAFE.copyMemory(srcByteArray, srcBaseOffset + (long)srcIndex, this.byteArray, this.addressOffset + (long)index, count);
        return count;
    }

    public void putBytes(int index, DirectBuffer srcBuffer, int srcIndex, int length) {
        this.boundsCheck(index, length);
        srcBuffer.boundsCheck(srcIndex, length);
        UNSAFE.copyMemory(srcBuffer.byteArray(), srcBuffer.addressOffset() + (long)srcIndex, this.byteArray, this.addressOffset + (long)index, length);
    }

    public String getStringUtf8(int offset, ByteOrder byteOrder) {
        int length = this.getInt(offset, byteOrder);
        return this.getStringUtf8(offset, length);
    }

    public String getStringUtf8(int offset, int length) {
        byte[] stringInBytes = new byte[length];
        this.getBytes(offset + 4, stringInBytes);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    public int putStringUtf8(int offset, String value, ByteOrder byteOrder, int maxEncodedSize) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : NULL_BYTES;
        if (bytes.length > maxEncodedSize) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedSize);
        }
        this.putInt(offset, bytes.length, byteOrder);
        this.putBytes(offset + 4, bytes);
        return 4 + bytes.length;
    }

    public String getStringWithoutLengthUtf8(int offset, int length) {
        byte[] stringInBytes = new byte[length];
        this.getBytes(offset, stringInBytes);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    public int putStringWithoutLengthUtf8(int offset, String value) {
        byte[] bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : NULL_BYTES;
        this.putBytes(offset, bytes);
        return bytes.length;
    }

    public void boundsCheck(int index, int length) {
        if (SHOULD_BOUNDS_CHECK && (index < 0 || length < 0 || index + length > this.capacity)) {
            throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, this.capacity));
        }
    }

    public ByteString getString(int offset) {
        byte terminator = 1;
        int index = offset;
        while (terminator != 0) {
            this.boundsCheck(index, 1);
            terminator = UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index++);
        }
        byte[] bytes = new byte[index - offset - 1];
        this.getBytes(offset, bytes);
        return new ByteString(bytes);
    }

    public void putString(int offset, ByteString value) {
        byte[] bytes = value.getBytes();
        this.putBytes(offset, bytes);
        this.putByte(offset + bytes.length, (byte)0);
    }

    public boolean getBoolean(int offset) {
        this.boundsCheck(offset, 1);
        return UNSAFE.getBoolean(this.byteArray, this.addressOffset + (long)offset);
    }

    public void putBoolean(int index, boolean value) {
        this.boundsCheck(index, 1);
        UNSAFE.putBoolean(this.byteArray, this.addressOffset + (long)index, value);
    }

    public char getChar(int offset) {
        this.boundsCheck(offset, 2);
        return UNSAFE.getChar(this.byteArray, this.addressOffset + (long)offset);
    }

    public void putChar(int index, char value) {
        this.boundsCheck(index, 4);
        UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    static {
        try {
            PrivilegedExceptionAction<Unsafe> action = new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    return (Unsafe)field.get(null);
                }
            };
            UNSAFE = AccessController.doPrivileged(action);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        SHOULD_BOUNDS_CHECK = !Boolean.getBoolean(DISABLE_BOUNDS_CHECKS_PROP_NAME);
        NULL_BYTES = "null".getBytes(StandardCharsets.UTF_8);
        NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
        ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    }
}

