/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver;

import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.parser.XMLParserException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class KeyResolverSpi {
    protected abstract boolean engineCanResolve(Element var1, String var2, StorageResolver var3);

    protected abstract PublicKey engineResolvePublicKey(Element var1, String var2, StorageResolver var3, boolean var4) throws KeyResolverException;

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        if (!this.engineCanResolve(element, string, storageResolver)) {
            return null;
        }
        return this.engineResolvePublicKey(element, string, storageResolver, bl);
    }

    protected abstract X509Certificate engineResolveX509Certificate(Element var1, String var2, StorageResolver var3, boolean var4) throws KeyResolverException;

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        if (!this.engineCanResolve(element, string, storageResolver)) {
            return null;
        }
        return this.engineResolveX509Certificate(element, string, storageResolver, bl);
    }

    protected abstract SecretKey engineResolveSecretKey(Element var1, String var2, StorageResolver var3, boolean var4) throws KeyResolverException;

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        if (!this.engineCanResolve(element, string, storageResolver)) {
            return null;
        }
        return this.engineResolveSecretKey(element, string, storageResolver, bl);
    }

    protected abstract PrivateKey engineResolvePrivateKey(Element var1, String var2, StorageResolver var3, boolean var4) throws KeyResolverException;

    public PrivateKey engineLookupAndResolvePrivateKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        if (!this.engineCanResolve(element, string, storageResolver)) {
            return null;
        }
        return this.engineResolvePrivateKey(element, string, storageResolver, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Element getDocFromBytes(byte[] byArray, boolean bl) throws KeyResolverException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            Document document = XMLUtils.read(byteArrayInputStream, bl);
            Element element = document.getDocumentElement();
            return element;
        }
        catch (XMLParserException xMLParserException) {
            throw new KeyResolverException(xMLParserException);
        }
        catch (IOException iOException) {
            throw new KeyResolverException(iOException);
        }
    }
}

