/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver;

import com.sun.org.apache.xml.internal.security.keys.keyresolver.ClassLoaderUtils;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.DEREncodedKeyValueResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.DSAKeyValueResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.ECKeyValueResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.KeyInfoReferenceResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.RSAKeyValueResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.RetrievalMethodResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509CertificateResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509DigestResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509IssuerSerialResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509SKIResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509SubjectNameResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.w3c.dom.Element;

public class KeyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(KeyResolver.class);
    private static List<KeyResolverSpi> resolverList = new CopyOnWriteArrayList<KeyResolverSpi>();
    private static final AtomicBoolean defaultResolversAdded = new AtomicBoolean();

    public static int length() {
        return resolverList.size();
    }

    public static final X509Certificate getX509Certificate(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        for (KeyResolverSpi keyResolverSpi : resolverList) {
            Object object;
            if (keyResolverSpi == null) {
                object = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", (Object[])object);
            }
            LOG.debug("check resolvability by class {}", keyResolverSpi.getClass());
            object = keyResolverSpi.engineLookupResolveX509Certificate(element, string, storageResolver, bl);
            if (object == null) continue;
            return object;
        }
        Object[] objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", objectArray);
    }

    public static final PublicKey getPublicKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        for (KeyResolverSpi keyResolverSpi : resolverList) {
            Object object;
            if (keyResolverSpi == null) {
                object = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", (Object[])object);
            }
            LOG.debug("check resolvability by class {}", keyResolverSpi.getClass());
            object = keyResolverSpi.engineLookupAndResolvePublicKey(element, string, storageResolver, bl);
            if (object == null) continue;
            return object;
        }
        Object[] objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", objectArray);
    }

    public static void register(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JavaUtils.checkRegisterPermission();
        KeyResolverSpi keyResolverSpi = (KeyResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(ClassLoaderUtils.loadClass(string, KeyResolver.class));
        KeyResolver.register(keyResolverSpi, false);
    }

    public static void registerAtStart(String string) {
        JavaUtils.checkRegisterPermission();
        KeyResolverSpi keyResolverSpi = null;
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            keyResolverSpi = (KeyResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(ClassLoaderUtils.loadClass(string, KeyResolver.class));
            KeyResolver.register(keyResolverSpi, true);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
        }
        if (reflectiveOperationException != null) {
            throw (IllegalArgumentException)new IllegalArgumentException("Invalid KeyResolver class name").initCause(reflectiveOperationException);
        }
    }

    public static void register(KeyResolverSpi keyResolverSpi, boolean bl) {
        JavaUtils.checkRegisterPermission();
        if (bl) {
            resolverList.add(0, keyResolverSpi);
        } else {
            resolverList.add(keyResolverSpi);
        }
    }

    public static void registerClassNames(List<String> list) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JavaUtils.checkRegisterPermission();
        ArrayList<KeyResolverSpi> arrayList = new ArrayList<KeyResolverSpi>(list.size());
        for (String string : list) {
            KeyResolverSpi keyResolverSpi = (KeyResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(ClassLoaderUtils.loadClass(string, KeyResolver.class));
            arrayList.add(keyResolverSpi);
        }
        resolverList.addAll(arrayList);
    }

    public static void registerDefaultResolvers() {
        if (defaultResolversAdded.compareAndSet(false, true)) {
            ArrayList<KeyResolverSpi> arrayList = new ArrayList<KeyResolverSpi>();
            arrayList.add(new RSAKeyValueResolver());
            arrayList.add(new DSAKeyValueResolver());
            arrayList.add(new X509CertificateResolver());
            arrayList.add(new X509SKIResolver());
            arrayList.add(new RetrievalMethodResolver());
            arrayList.add(new X509SubjectNameResolver());
            arrayList.add(new X509IssuerSerialResolver());
            arrayList.add(new DEREncodedKeyValueResolver());
            arrayList.add(new KeyInfoReferenceResolver());
            arrayList.add(new X509DigestResolver());
            arrayList.add(new ECKeyValueResolver());
            resolverList.addAll(arrayList);
        }
    }

    public static Iterator<KeyResolverSpi> iterator() {
        return new ResolverIterator(resolverList);
    }

    static class ResolverIterator
    implements Iterator<KeyResolverSpi> {
        private List<KeyResolverSpi> res;
        private Iterator<KeyResolverSpi> it;

        public ResolverIterator(List<KeyResolverSpi> list) {
            this.res = list;
            this.it = this.res.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public KeyResolverSpi next() {
            KeyResolverSpi keyResolverSpi = this.it.next();
            if (keyResolverSpi == null) {
                throw new RuntimeException("utils.resolver.noClass");
            }
            return keyResolverSpi;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove resolvers using the iterator");
        }
    }
}

