package com.fsck.k9.activity.compose;


import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.os.Bundle;
import androidx.annotation.IdRes;
import android.view.LayoutInflater;
import android.view.View;

import com.fsck.k9.ui.R;
import com.fsck.k9.view.HighlightDialogFragment;


public class PgpEncryptDescriptionDialog extends HighlightDialogFragment {
    public static PgpEncryptDescriptionDialog newInstance(@IdRes int showcaseView) {
        PgpEncryptDescriptionDialog dialog = new PgpEncryptDescriptionDialog();

        Bundle args = new Bundle();
        args.putInt(ARG_HIGHLIGHT_VIEW, showcaseView);
        dialog.setArguments(args);

        return dialog;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Activity activity = getActivity();

        @SuppressLint("InflateParams")
        View view = LayoutInflater.from(activity).inflate(R.layout.openpgp_encrypt_description_dialog, null);

        AlertDialog.Builder builder = new AlertDialog.Builder(activity);
        builder.setView(view);

        builder.setPositiveButton(R.string.openpgp_sign_only_ok, new OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });

        return builder.create();
    }
}
