# Appyx


Application mechanics for your Android apps, built on top of Jetpack Compose


## In a nutshell

Appyx comes with simple but powerful abstractions:

1. Represent your application as a composition of encapsulated components with their own lifecycle
2. Add dynamism to the component tree by granular navigation bits
3. Add custom on-screen and off-screen states for your components with history and powerful transitions

Read more in [Nodes and routing](basics/nodes-and-routing.md).


## Routing sources

Routing sources are the powerful engines driving all component state changes:

<img src="https://i.imgur.com/8gy3Ghb.gif" width="150"> <img src="https://i.imgur.com/Kj0P85H.gif" width="150"> <img src="https://i.imgur.com/N8rEPrJ.gif" width="150"> <img src="https://i.imgur.com/esLXh61.gif" width="150">

You can define as many custom states for your components as you wish. 

All state transitions can have history and be animated by all the power of Jetpack Compose. 

Appyx comes with both a set of common implementations (e.g. back stack, tab switching) and the ability to define your own.  

See [Routing sources](routingsources/index.md).


## Launch the demo app

Check out the project and launch the `:app` module for a quick demonstration


## Download

See the [Downloads page](setup/downloads.md).


## How to get started?

See the [Quick start guide](setup/quickstart.md).
