package com.bumble.appyx.app.composable

import androidx.compose.foundation.layout.*
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.ExperimentalUnitApi
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.TextUnitType
import androidx.compose.ui.unit.dp

@Composable
@ExperimentalUnitApi
fun Page(
    modifier: Modifier,
    title: String,
    body: String,
    illustration: @Composable BoxScope.() -> Unit
) {
    Column(
        modifier = modifier
            .fillMaxSize()
            .padding(
                start = 24.dp,
                end = 24.dp,
                top = 24.dp
            )
    ) {
        Box(
            modifier = Modifier
                .weight(0.65f)
                .fillMaxWidth()
        ) {
            illustration()
        }

        Spacer(Modifier.height(12.dp))

        Column(
            modifier = Modifier
                .weight(0.35f)
        ) {
            Text(
                text = title,
                style = MaterialTheme.typography.h4,
                modifier = Modifier
                    .fillMaxWidth()
                    .padding(bottom = 8.dp)
            )
            Column(
                modifier = Modifier
                    .verticalScroll(rememberScrollState())
            ) {
                Text(
                    text = body,
                    style = MaterialTheme.typography.body1.copy(
                        lineHeight = TextUnit(1.5f, TextUnitType.Em)
                    )
                )
            }

        }

    }
}
